/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public interface ExifTransform {
    public static final ExifTransform NO_TRANSFORM = new NoTransform();
    public static final ExifTransform ROTATE_CLOCKWISE = new RotateClockwise();
    public static final ExifTransform ROTATE_ANTI_CLOCKWISE = new RotateAntiClockwise();

    public boolean isXYTransposed();

    public boolean isThumbnailTransformRequired();

    public BufferedImage transformThumbnail(BufferedImage var1);

    public static final class RotateAntiClockwise
    extends RotateTransform {
        private RotateAntiClockwise() {
        }

        protected void makeTransform(AffineTransform at, BufferedImage originalImage) {
            at.rotate(Math.toRadians(-90.0));
            at.translate(-originalImage.getWidth(), 0.0);
        }
    }

    public static final class RotateClockwise
    extends RotateTransform {
        private RotateClockwise() {
        }

        protected void makeTransform(AffineTransform at, BufferedImage originalImage) {
            at.rotate(Math.toRadians(90.0));
            at.translate(0.0, -originalImage.getHeight());
        }
    }

    public static abstract class RotateTransform
    implements ExifTransform {
        public boolean isXYTransposed() {
            return true;
        }

        public boolean isThumbnailTransformRequired() {
            return true;
        }

        public BufferedImage transformThumbnail(BufferedImage originalImage) {
            AffineTransform at = new AffineTransform();
            this.makeTransform(at, originalImage);
            AffineTransformOp op = new AffineTransformOp(at, 1);
            BufferedImage destImage = new BufferedImage(originalImage.getHeight(), originalImage.getWidth(), originalImage.getType());
            return op.filter(originalImage, destImage);
        }

        protected abstract void makeTransform(AffineTransform var1, BufferedImage var2);
    }

    public static final class NoTransform
    implements ExifTransform {
        private NoTransform() {
        }

        public boolean isXYTransposed() {
            return false;
        }

        public boolean isThumbnailTransformRequired() {
            return false;
        }

        public BufferedImage transformThumbnail(BufferedImage originalImage) {
            return originalImage;
        }
    }
}

