/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.AbstractTiffTagWriter;
import au.com.lastweekend.jim.io.exif.DirectoryWriter;
import au.com.lastweekend.jim.io.exif.ExifDirectory;
import au.com.lastweekend.jim.io.exif.ExifDirectoryWriter;
import au.com.lastweekend.jim.io.exif.ExifTransform;
import au.com.lastweekend.jim.io.exif.GPSDirectory;
import au.com.lastweekend.jim.io.exif.GPSDirectoryWriter;
import au.com.lastweekend.jim.io.exif.ThumbnailTiffDirectory;
import au.com.lastweekend.jim.io.exif.ThumbnailTiffDirectoryWriter;
import au.com.lastweekend.jim.io.exif.TiffDirectory;
import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.util.LoggingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TiffDirectoryWriter
extends AbstractTiffTagWriter {
    private static final int START_OFFSET = 8;
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$exif$TiffDirectoryWriter == null ? (class$au$com$lastweekend$jim$io$exif$TiffDirectoryWriter = TiffDirectoryWriter.class$("au.com.lastweekend.jim.io.exif.TiffDirectoryWriter")) : class$au$com$lastweekend$jim$io$exif$TiffDirectoryWriter));
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$exif$TiffDirectoryWriter;

    public TiffDirectoryWriter(TiffDirectory directory) {
        this(directory, ExifTransform.NO_TRANSFORM);
    }

    public TiffDirectoryWriter(TiffDirectory directory, ExifTransform exifTransform) {
        super(directory, exifTransform);
        this.setDataFormat(new TiffTagFormat(directory.isMotorolaByteOrder()));
        this.setStartOffset(8);
    }

    public int getDirectoryLength() {
        return 8 + super.getDirectoryLength();
    }

    public void writeDirectory(OutputStream output) throws IOException {
        LoggingOutputStream loggingOutputStream;
        if (LOG.isDebugEnabled() && output instanceof LoggingOutputStream) {
            loggingOutputStream = (LoggingOutputStream)output;
            loggingOutputStream.pushOffset();
            LOG.debug((Object)("Starting Tiff directory at: " + loggingOutputStream.getStreamPosition()));
        }
        this.writeHeader(output);
        this.writeTags(output);
        if (LOG.isDebugEnabled() && output instanceof LoggingOutputStream) {
            loggingOutputStream = (LoggingOutputStream)output;
            LOG.debug((Object)("Ending Tiff directory at: " + loggingOutputStream.getStreamPosition()));
            loggingOutputStream.popOffset();
        }
    }

    private void writeHeader(OutputStream output) throws IOException {
        TiffDirectory tiffDirectory = (TiffDirectory)this.getDirectory();
        TiffTagFormat dataFormat = new TiffTagFormat(tiffDirectory.isMotorolaByteOrder());
        this.setDataFormat(dataFormat);
        if (tiffDirectory.isMotorolaByteOrder()) {
            output.write(77);
            output.write(77);
        } else {
            output.write(73);
            output.write(73);
        }
        dataFormat.write16bits(42, output);
        dataFormat.write32bits(8, output);
    }

    protected DirectoryWriter getLinkedDirectoryWriter(int startOffset) {
        Directory linkedDirectory = this.getDirectory().getLinkedDirectory();
        if (linkedDirectory != null && linkedDirectory instanceof ThumbnailTiffDirectory) {
            ThumbnailTiffDirectoryWriter writer = new ThumbnailTiffDirectoryWriter((ThumbnailTiffDirectory)linkedDirectory, this.getExifTransform());
            writer.setDataFormat(this.getDataFormat());
            writer.setStartOffset(startOffset);
            return writer;
        }
        return super.getLinkedDirectoryWriter(startOffset);
    }

    protected DirectoryWriter getDirectoryWriter(int tagType, Directory directory, int startOffset) {
        switch (tagType) {
            case 34665: {
                ExifDirectoryWriter exifDirectoryWriter = new ExifDirectoryWriter((ExifDirectory)directory, this.getExifTransform());
                exifDirectoryWriter.setDataFormat(this.getDataFormat());
                exifDirectoryWriter.setStartOffset(startOffset);
                return exifDirectoryWriter;
            }
            case 34853: {
                GPSDirectoryWriter gpsDirectoryWriter = new GPSDirectoryWriter((GPSDirectory)directory, this.getExifTransform());
                gpsDirectoryWriter.setDataFormat(this.getDataFormat());
                gpsDirectoryWriter.setStartOffset(startOffset);
                return gpsDirectoryWriter;
            }
        }
        return super.getDirectoryWriter(tagType, directory, startOffset);
    }

    protected Object getTransformedTagValue(int tagType) {
        if (this.getExifTransform().isXYTransposed()) {
            if (tagType == 282) {
                return this.getDirectory().getObject(283);
            }
            if (tagType == 283) {
                return this.getDirectory().getObject(282);
            }
        }
        return super.getTransformedTagValue(tagType);
    }

    public int getComponentCount() {
        throw new UnsupportedOperationException("Not expecting Tiff to be a sub directory");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

