/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.util.Rational;
import java.io.IOException;
import java.io.OutputStream;

public class TiffTagFormat {
    private boolean _isMotorolaByteOrder;
    public static final int FMT_DOUBLE = 12;
    public static final int FMT_SINGLE = 11;
    public static final int FMT_SRATIONAL = 10;
    public static final int FMT_SLONG = 9;
    public static final int FMT_SSHORT = 8;
    public static final int FMT_UNDEFINED = 7;
    public static final int FMT_SBYTE = 6;
    public static final int FMT_URATIONAL = 5;
    public static final int FMT_ULONG = 4;
    public static final int FMT_USHORT = 3;
    public static final int FMT_STRING = 2;
    public static final int FMT_BYTE = 1;
    private static final String BYTE = "BYTE";
    private static final String STRING = "STRING";
    private static final String USHORT = "USHORT";
    private static final String ULONG = "ULONG";
    private static final String URATIONAL = "URATIONAL";
    private static final String SBYTE = "SBYTE";
    private static final String UNDEFINED = "UNDEFINED";
    private static final String SSHORT = "SSHORT";
    private static final String SLONG = "SLONG";
    private static final String SRATIONAL = "SRATIONAL";
    private static final String SINGLE = "SINGLE";
    private static final String DOUBLE = "DOUBLE";
    private static final Class INT_ARRAY = array$I == null ? (array$I = TiffTagFormat.class$("[I")) : array$I;
    private static final Class BYTE_ARRAY = array$B == null ? (array$B = TiffTagFormat.class$("[B")) : array$B;
    private static final Class RATIONAL_ARRAY = array$Lau$com$lastweekend$jim$util$Rational == null ? (array$Lau$com$lastweekend$jim$util$Rational = TiffTagFormat.class$("[Lau.com.lastweekend.jim.util.Rational;")) : array$Lau$com$lastweekend$jim$util$Rational;
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    public static final int MAX_FORMAT_CODE = 12;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$Lau$com$lastweekend$jim$util$Rational;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$au$com$lastweekend$jim$util$Rational;
    static /* synthetic */ Class class$java$lang$String;

    public static String getNameFromFormatCode(int formatCode) throws MetadataException {
        switch (formatCode) {
            case 1: {
                return BYTE;
            }
            case 2: {
                return STRING;
            }
            case 3: {
                return USHORT;
            }
            case 4: {
                return ULONG;
            }
            case 5: {
                return URATIONAL;
            }
            case 6: {
                return SBYTE;
            }
            case 7: {
                return UNDEFINED;
            }
            case 8: {
                return SSHORT;
            }
            case 9: {
                return SLONG;
            }
            case 10: {
                return SRATIONAL;
            }
            case 11: {
                return SINGLE;
            }
            case 12: {
                return DOUBLE;
            }
        }
        throw new MetadataException("value '" + formatCode + "' does not represent a known data format.");
    }

    public TiffTagFormat(boolean isMotorolaByteCodeOrder) {
        this._isMotorolaByteOrder = isMotorolaByteCodeOrder;
    }

    public Object parse(byte[] data, int formatCode, int componentCount, int offset) throws TiffTagProcessingException {
        switch (formatCode) {
            case 2: {
                return this.readString(data, offset, componentCount);
            }
            case 5: 
            case 10: {
                if (componentCount == 1) {
                    return this.getRational(data, offset);
                }
                return this.getRationals(data, componentCount, offset);
            }
            case 1: 
            case 6: 
            case 7: {
                if (componentCount == 1) {
                    byte b = data[offset];
                    return new Byte(b);
                }
                byte[] bytes = new byte[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    bytes[i] = data[offset + i];
                }
                return bytes;
            }
            case 3: 
            case 8: {
                if (componentCount == 1) {
                    int i = this.get16Bits(data, offset);
                    return new Integer(i);
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = this.get16Bits(data, offset + i * 2);
                }
                return ints;
            }
            case 4: 
            case 9: {
                if (componentCount == 1) {
                    int i = this.get32Bits(data, offset);
                    return new Integer(i);
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = this.get32Bits(data, offset + i * 4);
                }
                return ints;
            }
        }
        throw new TiffTagProcessingException("unknown format code " + formatCode);
    }

    public int getFormattedSize(Object tagValue, int formatCode) {
        int bytesPerFormat = this.getBytesPerFormat(formatCode);
        return this.getComponentCount(tagValue) * bytesPerFormat;
    }

    /*
     * WARNING - void declaration
     */
    public int getComponentCount(Object tagValue) {
        void var2_2;
        int componentCount;
        if (tagValue.getClass().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = TiffTagFormat.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            componentCount = 1;
        } else if (tagValue.getClass().equals(INT_ARRAY)) {
            int[] tagValues = (int[])tagValue;
            componentCount = tagValues.length;
        } else if (tagValue.getClass().equals(class$java$lang$Byte == null ? (class$java$lang$Byte = TiffTagFormat.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            componentCount = 1;
        } else if (tagValue.getClass().equals(BYTE_ARRAY)) {
            byte[] tagValues = (byte[])tagValue;
            componentCount = tagValues.length;
        } else if (tagValue.getClass().equals(class$au$com$lastweekend$jim$util$Rational == null ? (class$au$com$lastweekend$jim$util$Rational = TiffTagFormat.class$("au.com.lastweekend.jim.util.Rational")) : class$au$com$lastweekend$jim$util$Rational)) {
            componentCount = 1;
        } else if (tagValue.getClass().equals(RATIONAL_ARRAY)) {
            Rational[] tagValues = (Rational[])tagValue;
            componentCount = tagValues.length;
        } else if (tagValue.getClass().equals(class$java$lang$String == null ? (class$java$lang$String = TiffTagFormat.class$("java.lang.String")) : class$java$lang$String)) {
            String tagString = (String)tagValue;
            componentCount = tagString.length() + 1;
        } else {
            throw new RuntimeException("Unknown tag object type" + tagValue.getClass());
        }
        return (int)var2_2;
    }

    public void writeValue(Object tagValue, int formatCode, OutputStream output) throws IOException {
        if (tagValue.getClass().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = TiffTagFormat.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            this.writeInt((Integer)tagValue, formatCode, output);
        } else if (tagValue.getClass().equals(INT_ARRAY)) {
            int[] tagValues = (int[])tagValue;
            for (int i = 0; i < tagValues.length; ++i) {
                this.writeInt(tagValues[i], formatCode, output);
            }
        } else if (tagValue.getClass().equals(class$java$lang$Byte == null ? (class$java$lang$Byte = TiffTagFormat.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            Byte byteValue = (Byte)tagValue;
            this.writeByte(byteValue, formatCode, output);
        } else if (tagValue.getClass().equals(BYTE_ARRAY)) {
            byte[] tagValues = (byte[])tagValue;
            for (int i = 0; i < tagValues.length; ++i) {
                this.writeByte(tagValues[i], formatCode, output);
            }
        } else if (tagValue.getClass().equals(class$au$com$lastweekend$jim$util$Rational == null ? (class$au$com$lastweekend$jim$util$Rational = TiffTagFormat.class$("au.com.lastweekend.jim.util.Rational")) : class$au$com$lastweekend$jim$util$Rational)) {
            this.writeRational((Rational)tagValue, formatCode, output);
        } else if (tagValue.getClass().equals(RATIONAL_ARRAY)) {
            Rational[] tagValues = (Rational[])tagValue;
            for (int i = 0; i < tagValues.length; ++i) {
                this.writeRational(tagValues[i], formatCode, output);
            }
        } else if (tagValue.getClass().equals(class$java$lang$String == null ? (class$java$lang$String = TiffTagFormat.class$("java.lang.String")) : class$java$lang$String)) {
            String tagString = (String)tagValue;
            this.writeString(tagString, formatCode, output);
        } else {
            throw new RuntimeException("Unknown tag object type" + tagValue.getClass());
        }
    }

    private void writeString(String tagString, int formatCode, OutputStream output) throws IOException {
        output.write(tagString.getBytes());
        output.write(0);
    }

    private void writeRational(Rational rational, int formatCode, OutputStream output) throws IOException {
        this.write32bits(rational.getNumerator(), output);
        this.write32bits(rational.getDenominator(), output);
    }

    private void writeInt(int i, int formatCode, OutputStream output) throws IOException {
        switch (formatCode) {
            case 3: 
            case 8: {
                this.write16bits(i, output);
                break;
            }
            case 4: 
            case 9: {
                this.write32bits(i, output);
                break;
            }
            default: {
                throw new RuntimeException("Bad format code: " + formatCode + "for int " + i);
            }
        }
    }

    private void writeByte(byte byteValue, int formatCode, OutputStream output) throws IOException {
        switch (formatCode) {
            case 1: 
            case 6: 
            case 7: {
                output.write(byteValue);
                break;
            }
            default: {
                throw new RuntimeException("Bad format code:" + formatCode + "for Byte" + byteValue);
            }
        }
    }

    private Object getRationals(byte[] data, int componentCount, int offset) {
        Rational[] rationals = new Rational[componentCount];
        for (int i = 0; i < componentCount; ++i) {
            int componentOffset = 8 * i;
            rationals[i] = this.getRational(data, offset + componentOffset);
        }
        return rationals;
    }

    private Rational getRational(byte[] data, int offset) {
        Rational rational = new Rational(this.get32Bits(data, offset), this.get32Bits(data, offset + 4));
        return rational;
    }

    private String readString(byte[] data, int offset, int maxLength) {
        int length;
        for (length = 0; offset + length < data.length && data[offset + length] != 0 && length < maxLength; ++length) {
        }
        return new String(data, offset, length);
    }

    public int getBytesPerFormat(int formatCode) {
        return BYTES_PER_FORMAT[formatCode];
    }

    public int getByteCount(int formatCode, int componentCount) {
        int byteCount = componentCount * this.getBytesPerFormat(formatCode);
        return byteCount;
    }

    public int get16Bits(byte[] data, int offset) {
        if (offset < 0 || offset >= data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + offset + " where max index is " + (data.length - 1) + ")");
        }
        if (this._isMotorolaByteOrder) {
            return data[offset] << 8 & 0xFF00 | data[offset + 1] & 0xFF;
        }
        return data[offset + 1] << 8 & 0xFF00 | data[offset] & 0xFF;
    }

    public int get32Bits(byte[] data, int offset) {
        if (offset < 0 || offset >= data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + offset + " where max index is " + (data.length - 1) + ")");
        }
        if (this._isMotorolaByteOrder) {
            return data[offset] << 24 & 0xFF000000 | data[offset + 1] << 16 & 0xFF0000 | data[offset + 2] << 8 & 0xFF00 | data[offset + 3] & 0xFF;
        }
        return data[offset + 3] << 24 & 0xFF000000 | data[offset + 2] << 16 & 0xFF0000 | data[offset + 1] << 8 & 0xFF00 | data[offset] & 0xFF;
    }

    public void write16bits(int value, OutputStream output) throws IOException {
        byte lowByte = (byte)(value & 0xFF);
        byte highByte = (byte)((value & 0xFF00) >> 8);
        if (this._isMotorolaByteOrder) {
            output.write(highByte);
            output.write(lowByte);
        } else {
            output.write(lowByte);
            output.write(highByte);
        }
    }

    public void write32bits(int value, OutputStream output) throws IOException {
        byte b1 = (byte)(value & 0xFF);
        byte b2 = (byte)((value & 0xFF00) >> 8);
        byte b3 = (byte)((value & 0xFF0000) >> 16);
        byte b4 = (byte)((value & 0xFF000000) >> 24);
        if (this._isMotorolaByteOrder) {
            output.write(b4);
            output.write(b3);
            output.write(b2);
            output.write(b1);
        } else {
            output.write(b1);
            output.write(b2);
            output.write(b3);
            output.write(b4);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

