/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.HuffmanTable;
import au.com.lastweekend.jim.io.jpeg.JpegBitBuffer;
import au.com.lastweekend.jim.io.jpeg.JpegBitOps;
import au.com.lastweekend.jim.io.jpeg.JpegBitOutput;
import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.ScanComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DCTBlock {
    protected static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$DCTBlock == null ? (class$au$com$lastweekend$jim$io$jpeg$DCTBlock = DCTBlock.class$("au.com.lastweekend.jim.io.jpeg.DCTBlock")) : class$au$com$lastweekend$jim$io$jpeg$DCTBlock));
    public static final byte[][] ZIG_ZAG_ORDER = new byte[][]{{0, 2, 3, 9, 10, 20, 21, 35}, {1, 4, 8, 11, 19, 22, 34, 36}, {5, 7, 12, 18, 23, 33, 37, 48}, {6, 13, 17, 24, 32, 38, 47, 49}, {14, 16, 25, 31, 39, 46, 50, 57}, {15, 26, 30, 40, 45, 51, 56, 58}, {27, 29, 41, 44, 52, 55, 59, 62}, {28, 42, 43, 53, 54, 60, 61, 63}};
    public static final byte[] ZIG_ZAG_X = new byte[]{0, 1, 0, 0, 1, 2, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 6, 5, 4, 3, 2, 1, 0, 1, 2, 3, 4, 5, 6, 7, 7, 6, 5, 4, 3, 2, 3, 4, 5, 6, 7, 7, 6, 5, 4, 5, 6, 7, 7, 6, 7};
    public static final byte[] ZIG_ZAG_Y = new byte[]{0, 0, 1, 2, 1, 0, 0, 1, 2, 3, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 7, 6, 5, 4, 3, 2, 1, 2, 3, 4, 5, 6, 7, 7, 6, 5, 4, 3, 4, 5, 6, 7, 7, 6, 5, 6, 7, 7};
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$DCTBlock;

    public abstract void writeCoefficients(ScanComponent var1, JpegBitOutput var2) throws JpegProcessingException;

    public abstract void readCoefficients(ScanComponent var1, JpegBitBuffer var2) throws JpegProcessingException;

    public abstract int getDCCoefficient();

    public abstract byte[] getIndexes();

    public abstract short[] getNonZeroValues();

    protected final void encodeDCCoefficient(HuffmanTable dcHuffmanTable, int dcPredictor, JpegBitOutput bitOutput) throws JpegProcessingException {
        int diff = this.getDCCoefficient() - dcPredictor;
        int bits = JpegBitOps.getCategorySize(diff);
        if (LOG.isDebugEnabled()) {
            bitOutput.debug("DCenc: pred=" + dcPredictor + " diff=" + diff + " bits=" + bits);
        }
        dcHuffmanTable.encode(bits, bitOutput);
        if (diff > 0) {
            bitOutput.writeBits(bits, diff);
        } else if (diff < 0) {
            bitOutput.writeBits(bits, diff - 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

