/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegSegment;
import au.com.lastweekend.jim.io.jpeg.read.AllSegmentsReaderRegistry;
import au.com.lastweekend.jim.io.jpeg.read.JpegCompressedDataReader;
import au.com.lastweekend.jim.io.jpeg.read.JpegSegmentReader;
import au.com.lastweekend.jim.io.jpeg.read.JpegSegmentReaderRegistry;
import au.com.lastweekend.jim.io.jpeg.read.RawSegmentReader;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.Metadata;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JpegReader {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$JpegReader == null ? (class$au$com$lastweekend$jim$io$jpeg$JpegReader = JpegReader.class$("au.com.lastweekend.jim.io.jpeg.JpegReader")) : class$au$com$lastweekend$jim$io$jpeg$JpegReader));
    private static final JpegSegmentReaderRegistry DEFAULT_REGISTRY = new AllSegmentsReaderRegistry();
    private final JpegSegmentReaderRegistry _registry;
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$JpegReader;

    public JpegReader() {
        this(DEFAULT_REGISTRY);
    }

    public JpegReader(JpegSegmentReaderRegistry registry) {
        this._registry = registry;
    }

    public Metadata readMetadata(File jpegFile) throws JpegProcessingException {
        Metadata metadata = new Metadata();
        BufferedInputStream inStream = this.getJpegInputStream(jpegFile);
        this.readMetadata(metadata, inStream);
        return metadata;
    }

    public void readMetadata(Metadata metadata, File imageFile) throws JpegProcessingException {
        this.readMetadata(metadata, this.getJpegInputStream(imageFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metadata readImage(File imageFile) throws JpegProcessingException {
        Metadata metadata = new Metadata();
        BufferedInputStream inStream = this.getJpegInputStream(imageFile);
        try {
            this.readMetadata(metadata, inStream);
            this.readImage(metadata, inStream);
        }
        finally {
            this.closeStream(inStream);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metadata readTransformableImage(File imageFile) throws JpegProcessingException {
        Metadata metadata = new Metadata();
        BufferedInputStream inStream = this.getJpegInputStream(imageFile);
        try {
            this.readMetadata(metadata, inStream);
            this.readTransformableImage(metadata, inStream);
        }
        finally {
            this.closeStream(inStream);
        }
        return metadata;
    }

    private void readTransformableImage(Metadata metadata, BufferedInputStream input) throws JpegProcessingException {
        JpegCompressedDataReader dataReader = new JpegCompressedDataReader(input);
        dataReader.readTransformableData(metadata);
    }

    private void readImage(Metadata metadata, InputStream input) throws JpegProcessingException {
        JpegCompressedDataReader dataReader = new JpegCompressedDataReader(input);
        dataReader.readRawData(metadata);
    }

    private void readMetadata(Metadata metadata, InputStream input) throws JpegProcessingException {
        this.checkValidJpegHeaderBytes(input);
        this.readSegments(metadata, input);
    }

    private BufferedInputStream getJpegInputStream(File jpegFile) throws JpegProcessingException {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(jpegFile);
        }
        catch (FileNotFoundException e) {
            throw new JpegProcessingException(e);
        }
        return new BufferedInputStream(inputStream);
    }

    private void closeStream(BufferedInputStream inStream) {
        try {
            inStream.close();
        }
        catch (IOException e) {
            LOG.warn((Object)("exception closing stream " + inStream), (Throwable)e);
        }
    }

    private void checkValidJpegHeaderBytes(InputStream fileStream) throws JpegProcessingException {
        byte[] header = new byte[2];
        try {
            fileStream.read(header, 0, 2);
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
        if ((header[0] & 0xFF) != 255 || (header[1] & 0xFF) != 216) {
            throw new JpegProcessingException("Did not find Jpeg magic number at start of file");
        }
    }

    private void readSegments(Metadata metadata, InputStream input) throws JpegProcessingException {
        boolean foundSOS = false;
        do {
            try {
                byte segmentBoundary = (byte)(input.read() & 0xFF);
                if (segmentBoundary != -1) {
                    throw new JpegProcessingException("expected jpeg segment start identifier 0xFF, not 0x" + Integer.toHexString(segmentBoundary));
                }
                byte identifier = (byte)(input.read() & 0xFF);
                byte[] segmentLengthBytes = new byte[2];
                input.read(segmentLengthBytes, 0, 2);
                int length = segmentLengthBytes[0] << 8 & 0xFF00 | segmentLengthBytes[1] & 0xFF;
                JpegSegment segment = this.getSegment(identifier, length -= 2, input);
                JpegSegmentReader segmentReader = this.getSegmentReader(identifier);
                if (segmentReader != null) {
                    Directory segmentDirectory = segmentReader.extractDirectory(segment);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Reading " + length + " byte Jpeg segment with marker: " + Integer.toHexString(identifier) + " using " + segmentReader.getClass().getName()));
                    }
                    if (segmentDirectory == null) {
                        LOG.warn((Object)("Reader: " + segmentReader.getClass().getName() + " unable to decode segment with identifier " + Integer.toHexString(identifier)));
                        segmentDirectory = new RawSegmentReader().extractDirectory(segment);
                    }
                    metadata.addDirectory(segmentDirectory);
                }
                foundSOS = identifier == -38;
            }
            catch (IOException e) {
                throw new JpegProcessingException(e);
            }
        } while (!foundSOS);
    }

    private JpegSegment getSegment(byte identifier, int length, InputStream input) throws JpegProcessingException {
        byte[] segmentData = new byte[length];
        try {
            int readCount = input.read(segmentData);
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
        JpegSegment segment = new JpegSegment(identifier, length, segmentData);
        return segment;
    }

    private JpegSegmentReader getSegmentReader(byte identifier) throws JpegProcessingException {
        return this._registry.getSegmentReader(identifier);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

