/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.DCTBlock;
import au.com.lastweekend.jim.io.jpeg.HuffmanTable;
import au.com.lastweekend.jim.io.jpeg.JpegBitBuffer;
import au.com.lastweekend.jim.io.jpeg.JpegBitOps;
import au.com.lastweekend.jim.io.jpeg.JpegBitOutput;
import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.ScanComponent;

public class RunLengthEncodedDCTBlock
extends DCTBlock {
    private short _dcCoefficient;
    private byte[] _indexes;
    private short[] _nonZeroValues;
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();

    public void readCoefficients(ScanComponent component, JpegBitBuffer bitBuffer) throws JpegProcessingException {
        this._dcCoefficient = (short)this.decodeDCCoefficient(component.getDCHuffmanTable(), component.getDCPredictor(), bitBuffer);
        byte[] workingIndexes = component.getWorkingIndexes();
        short[] workingValues = component.getWorkingValues();
        int numACValues = this.decodeACCoefficients(component.getACHuffmanTable(), workingIndexes, workingValues, bitBuffer);
        this._indexes = new byte[numACValues];
        this._nonZeroValues = new short[numACValues];
        System.arraycopy(workingIndexes, 0, this._indexes, 0, numACValues);
        System.arraycopy(workingValues, 0, this._nonZeroValues, 0, numACValues);
    }

    private int decodeDCCoefficient(HuffmanTable dcHuffmanTable, int dcPredictor, JpegBitBuffer bitBuffer) throws JpegProcessingException {
        byte bits = dcHuffmanTable.decode(bitBuffer);
        int diff = 0;
        if (bits > 0) {
            diff = bitBuffer.getBits(bits);
            diff = JpegBitOps.extend(diff, bits);
        }
        if (this.isDebugEnabled()) {
            LOG.debug((Object)("DC: pred=" + dcPredictor + " diff=" + diff + " bits=" + bits));
        }
        return dcPredictor + diff;
    }

    private boolean isDebugEnabled() {
        return DEBUG_ENABLED;
    }

    private int decodeACCoefficients(HuffmanTable acHuffmanTable, byte[] indexes, short[] values, JpegBitBuffer bitBuffer) throws JpegProcessingException {
        int numValues = 0;
        int currentIndex = 1;
        while (currentIndex < 64) {
            byte rrrrssss = acHuffmanTable.decode(bitBuffer);
            int runLength = JpegBitOps.getHigh4Bits(rrrrssss);
            int bits = JpegBitOps.getLow4Bits(rrrrssss);
            if (bits == 0) {
                if (runLength == 15) {
                    currentIndex += 16;
                    if (!this.isDebugEnabled()) continue;
                    LOG.debug((Object)("AC: rrrr=" + runLength + " ssss=" + bits + " value=0"));
                    continue;
                }
                currentIndex = 64;
                if (!this.isDebugEnabled()) continue;
                LOG.debug((Object)"AC: no more co-efficients");
                continue;
            }
            indexes[numValues] = (byte)((currentIndex += runLength) & 0xFF);
            values[numValues] = (short)JpegBitOps.extend(bitBuffer.getBits(bits), bits);
            if (this.isDebugEnabled()) {
                LOG.debug((Object)("AC: rrrr=" + runLength + " ssss=" + bits + " value=" + values[numValues]));
            }
            ++numValues;
            ++currentIndex;
        }
        return numValues;
    }

    public void writeCoefficients(ScanComponent component, JpegBitOutput bitOutput) throws JpegProcessingException {
        this.encodeDCCoefficient(component.getDCHuffmanTable(), component.getDCPredictor(), bitOutput);
        this.encodeACCoefficients(component.getACHuffmanTable(), bitOutput);
    }

    private void encodeACCoefficients(HuffmanTable acHuffmanTable, JpegBitOutput bitOutput) throws JpegProcessingException {
        int currentIndex = 1;
        for (int i = 0; i < this._indexes.length; ++i) {
            int index = this._indexes[i];
            short value = this._nonZeroValues[i];
            int runLength = index - currentIndex;
            currentIndex = index;
            while (runLength > 15) {
                runLength -= 16;
                acHuffmanTable.encode(240, bitOutput);
                if (!bitOutput.isDebugEnabled()) continue;
                bitOutput.debug("ACenc: ZRL for 16 consecutive zeroes");
            }
            int size = JpegBitOps.getCategorySize(value);
            int rrrrssss = (runLength << 4) + size & 0xFF;
            if (bitOutput.isDebugEnabled()) {
                bitOutput.debug("ACenc rrrr=" + runLength + " ssss=" + size + " value=" + value);
            }
            acHuffmanTable.encode(rrrrssss, bitOutput);
            if (value < 0) {
                value = (short)(value - 1);
            }
            bitOutput.writeBits(size, value);
            ++currentIndex;
        }
        if (currentIndex < 64) {
            acHuffmanTable.encode(0, bitOutput);
        }
    }

    public byte[] getIndexes() {
        return this._indexes;
    }

    public short[] getNonZeroValues() {
        return this._nonZeroValues;
    }

    public int getDCCoefficient() {
        return this._dcCoefficient;
    }

    public int[][] getCoefficients() {
        throw new UnsupportedOperationException("Only a transform should convert from zero run length coding to matrix coding");
    }
}

