/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.read;

import au.com.lastweekend.jim.io.jpeg.HuffmanTableDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegSegment;
import au.com.lastweekend.jim.io.jpeg.read.JpegSegmentReader;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HuffmanTableSegmentReader
implements JpegSegmentReader {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$read$HuffmanTableSegmentReader == null ? (class$au$com$lastweekend$jim$io$jpeg$read$HuffmanTableSegmentReader = HuffmanTableSegmentReader.class$("au.com.lastweekend.jim.io.jpeg.read.HuffmanTableSegmentReader")) : class$au$com$lastweekend$jim$io$jpeg$read$HuffmanTableSegmentReader));
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$read$HuffmanTableSegmentReader;

    public Directory extractDirectory(JpegSegment segment) throws JpegProcessingException {
        HuffmanTableDirectory firstHuffmanDirectory = null;
        Directory previousHuffmanDirectory = null;
        int offset = 0;
        do {
            boolean isACTable = segment.getHigh4Bits(offset) == 1;
            byte tableID = segment.getLow4Bits(offset);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HUFF id=" + tableID + " isAC=" + isACTable + " at offset " + offset));
            }
            ++offset;
            byte[] numberOfHuffmanCodesByLength = new byte[16];
            int totalNumberOfCodes = 0;
            for (int i = 0; i < 16; ++i) {
                byte numberOfCodes = segment.get8Bits(offset++);
                totalNumberOfCodes += numberOfCodes;
                numberOfHuffmanCodesByLength[i] = numberOfCodes;
            }
            byte[][] huffmanValues = new byte[16][];
            for (int i = 0; i < 16; ++i) {
                int numberOfCodes = numberOfHuffmanCodesByLength[i];
                huffmanValues[i] = new byte[numberOfCodes];
                for (int j = 0; j < numberOfCodes; ++j) {
                    huffmanValues[i][j] = segment.get8Bits(offset++);
                }
            }
            HuffmanTableDirectory thisDirectory = new HuffmanTableDirectory((HuffmanTableDirectory)previousHuffmanDirectory, isACTable, tableID, huffmanValues, segment);
            if (firstHuffmanDirectory == null) {
                firstHuffmanDirectory = thisDirectory;
            } else {
                try {
                    previousHuffmanDirectory.addLinkedDirectory(thisDirectory);
                }
                catch (MetadataException e) {
                    throw new JpegProcessingException(e);
                }
            }
            previousHuffmanDirectory = thisDirectory;
        } while (offset < segment.getSize());
        return firstHuffmanDirectory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

