/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.write;

import au.com.lastweekend.jim.io.exif.ExifTransform;
import au.com.lastweekend.jim.io.jpeg.DCTBlock;
import au.com.lastweekend.jim.io.jpeg.MatrixEncodedDCTBlock;
import au.com.lastweekend.jim.io.jpeg.ScanComponent;

public interface JpegTransform {
    public static final JpegTransform NO_TRANSFORM = new NoTransform();
    public static final JpegTransform ROTATE_CLOCKWISE = new RotateClockwise();
    public static final JpegTransform ROTATE_ANTI_CLOCKWISE = new RotateAntiClockwise();

    public Coordinate transform(int var1, int var2);

    public Coordinate reverseTransform(int var1, int var2, int var3, int var4);

    public int transformZZIndex(int var1);

    public DCTBlock transformBlock(ScanComponent var1, DCTBlock var2);

    public ExifTransform getExifTransform();

    public static final class RotateAntiClockwise
    extends Rotate90 {
        private RotateAntiClockwise() {
        }

        public Coordinate reverseTransform(int x, int y, int width, int height) {
            return new Coordinate(height - 1 - y, x, height, width);
        }

        protected void transformCoefficient(int x, int y, int coefficientValue, int[][] transformedCoefficients) {
            transformedCoefficients[y][x] = (x & 1) == 0 ? coefficientValue : -coefficientValue;
        }

        public ExifTransform getExifTransform() {
            return ExifTransform.ROTATE_ANTI_CLOCKWISE;
        }
    }

    public static final class RotateClockwise
    extends Rotate90 {
        private RotateClockwise() {
        }

        public Coordinate reverseTransform(int x, int y, int width, int height) {
            return new Coordinate(y, width - 1 - x, height, width);
        }

        protected void transformCoefficient(int x, int y, int coefficientValue, int[][] transformedCoefficients) {
            transformedCoefficients[y][x] = (y & 1) == 0 ? coefficientValue : -coefficientValue;
        }

        public ExifTransform getExifTransform() {
            return ExifTransform.ROTATE_CLOCKWISE;
        }
    }

    public static abstract class Rotate90
    implements JpegTransform {
        public Coordinate transform(int width, int height) {
            return new Coordinate(height, width);
        }

        public int transformZZIndex(int i) {
            return DCTBlock.ZIG_ZAG_ORDER[DCTBlock.ZIG_ZAG_Y[i]][DCTBlock.ZIG_ZAG_X[i]];
        }

        public DCTBlock transformBlock(ScanComponent component, DCTBlock block) {
            int[][] transformedCoefficients = new int[8][8];
            transformedCoefficients[0][0] = block.getDCCoefficient();
            short[] nonZeroValues = block.getNonZeroValues();
            byte[] indexes = block.getIndexes();
            byte lastNonZeroIndex = indexes.length > 0 ? indexes[indexes.length - 1] : (byte)0;
            for (int i = 0; i < indexes.length; ++i) {
                short coefficientValue = nonZeroValues[i];
                byte x = DCTBlock.ZIG_ZAG_X[indexes[i]];
                byte y = DCTBlock.ZIG_ZAG_Y[indexes[i]];
                this.transformCoefficient(x, y, coefficientValue, transformedCoefficients);
            }
            return new MatrixEncodedDCTBlock(transformedCoefficients, 63);
        }

        protected abstract void transformCoefficient(int var1, int var2, int var3, int[][] var4);
    }

    public static final class NoTransform
    implements JpegTransform {
        private NoTransform() {
        }

        public Coordinate transform(int width, int height) {
            return new Coordinate(width, height);
        }

        public Coordinate reverseTransform(int x, int y, int width, int height) {
            return new Coordinate(x, y, width, height);
        }

        public DCTBlock transformBlock(ScanComponent component, DCTBlock sampleBlock) {
            return sampleBlock;
        }

        public int transformZZIndex(int i) {
            return i;
        }

        public ExifTransform getExifTransform() {
            return ExifTransform.NO_TRANSFORM;
        }
    }

    public static final class Coordinate {
        private int _x;
        private int _y;
        private int _width;
        private int _height;

        public Coordinate(int x, int y, int width, int height) {
            this._x = x;
            this._y = y;
            this._width = width;
            this._height = height;
        }

        public Coordinate(int width, int height) {
            this(-1, -1, width, height);
        }

        public int getWidth() {
            return this._width;
        }

        public int getHeight() {
            return this._height;
        }

        public int getX() {
            return this._x;
        }

        public int getY() {
            return this._y;
        }
    }
}

