/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.write;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegStartOfFrameDirectory;
import au.com.lastweekend.jim.io.jpeg.write.AbstractSegmentDirectoryWriter;
import au.com.lastweekend.jim.io.jpeg.write.JpegTransform;
import au.com.lastweekend.jim.io.metadata.Directory;
import java.io.IOException;
import java.io.OutputStream;

public class StartOfFrameSegmentWriter
extends AbstractSegmentDirectoryWriter {
    private JpegTransform _transform;

    public StartOfFrameSegmentWriter(JpegTransform transform) {
        this._transform = transform;
    }

    public StartOfFrameSegmentWriter() {
        this(JpegTransform.NO_TRANSFORM);
    }

    public void writeDirectory(Directory directory, OutputStream output) throws JpegProcessingException {
        this.writeStartOfFrameDirectory((JpegStartOfFrameDirectory)directory, output);
    }

    private void writeStartOfFrameDirectory(JpegStartOfFrameDirectory directory, OutputStream output) throws JpegProcessingException {
        byte framePrecision = directory.getFramePrecisison();
        JpegTransform.Coordinate frameDimensions = this._transform.transform(directory.getFrameWidth(), directory.getFrameHeight());
        int frameHeight = frameDimensions.getHeight();
        int frameWidth = frameDimensions.getWidth();
        int components = directory.getNumberOfComponents();
        int segmentLength = 8 + components * 3;
        try {
            this.writeHeader((byte)-64, segmentLength, output);
            output.write(framePrecision);
            this.writeShort(frameHeight, output);
            this.writeShort(frameWidth, output);
            output.write(components);
            for (int i = 0; i < components; ++i) {
                byte componentId = directory.getComponentID(i);
                JpegTransform.Coordinate samplingFactors = this._transform.transform(directory.getHorizontalSamplingFactor(i), directory.getVerticalSamplingFactor(i));
                int verticalSamplingFactor = samplingFactors.getHeight() & 0xFF;
                int horizontalSamplingFactor = samplingFactors.getWidth() & 0xFF;
                int compressedSamplingFactor = (horizontalSamplingFactor << 4) + verticalSamplingFactor;
                byte quantisationTable = directory.getQuantisationTable(i);
                output.write(componentId);
                output.write(compressedSamplingFactor);
                output.write(quantisationTable);
            }
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
    }
}

