/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GlyphMetrics;

public class TextStyle {
    public Font font;
    public Color foreground;
    public Color background;
    public boolean underline;
    public boolean strikeout;
    public GlyphMetrics metrics;
    public int rise;

    public TextStyle(Font font, Color foreground, Color background) {
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (foreground != null && foreground.isDisposed()) {
            SWT.error(5);
        }
        if (background != null && background.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        this.foreground = foreground;
        this.background = background;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof TextStyle)) {
            return false;
        }
        TextStyle style = (TextStyle)object;
        if (this.foreground != null ? !this.foreground.equals(style.foreground) : style.foreground != null) {
            return false;
        }
        if (this.background != null ? !this.background.equals(style.background) : style.background != null) {
            return false;
        }
        if (this.font != null ? !this.font.equals(style.font) : style.font != null) {
            return false;
        }
        if (this.metrics != null || style.metrics != null) {
            return false;
        }
        if (this.underline != style.underline) {
            return false;
        }
        if (this.strikeout != style.strikeout) {
            return false;
        }
        return this.rise == style.rise;
    }

    public int hashCode() {
        int hash = 0;
        if (this.foreground != null) {
            hash ^= this.foreground.hashCode();
        }
        if (this.background != null) {
            hash ^= this.background.hashCode();
        }
        if (this.font != null) {
            hash ^= this.font.hashCode();
        }
        if (this.metrics != null) {
            hash ^= this.metrics.hashCode();
        }
        if (this.underline) {
            hash ^= hash;
        }
        if (this.strikeout) {
            hash ^= hash;
        }
        return hash ^= this.rise;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("TextStyle {");
        int startLength = buffer.length();
        if (this.font != null) {
            if (buffer.length() > startLength) {
                buffer.append(", ");
            }
            buffer.append("font=");
            buffer.append(this.font);
        }
        if (this.foreground != null) {
            if (buffer.length() > startLength) {
                buffer.append(", ");
            }
            buffer.append("foreground=");
            buffer.append(this.foreground);
        }
        if (this.background != null) {
            if (buffer.length() > startLength) {
                buffer.append(", ");
            }
            buffer.append("background=");
            buffer.append(this.background);
        }
        if (this.underline) {
            if (buffer.length() > startLength) {
                buffer.append(", ");
            }
            buffer.append("underlined");
        }
        if (this.strikeout) {
            if (buffer.length() > startLength) {
                buffer.append(", ");
            }
            buffer.append("striked out");
        }
        if (this.rise != 0) {
            if (buffer.length() > startLength) {
                buffer.append(", ");
            }
            buffer.append("rise=");
            buffer.append(this.rise);
        }
        if (this.metrics != null) {
            if (buffer.length() > startLength) {
                buffer.append(", ");
            }
            buffer.append("metrics=");
            buffer.append(this.metrics);
        }
        buffer.append("}");
        return buffer.toString();
    }
}

