/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.zooomr;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.Task;
import org.scohen.juploadr.uploadapi.zooomr.ZooomrRestApi;
import org.scohen.juploadr.uploadapi.zooomr.photosets.CreatePhotoSet;

public class CreateAllPhotosetsTask
extends Task {
    private Collection sets;
    private ZooomrRestApi api;
    private String photoSetName;
    private int current;

    public CreateAllPhotosetsTask(Collection photoSets, ZooomrRestApi api) {
        this.sets = this.getNewPhotoSets(photoSets);
        this.api = api;
        this.max = this.sets.size() - 1;
        this.min = 0;
    }

    public String getTitle() {
        return Messages.getString((String)"juploadr.ui.task.createphotsets.creating") + this.max + Messages.getString((String)"juploadr.ui.task.createphotsets.photosets");
    }

    public boolean hasSetsToCreate() {
        return this.sets.size() > 0;
    }

    private Collection getNewPhotoSets(Collection photoSets) {
        LinkedList<PhotoSet> rv = new LinkedList<PhotoSet>();
        Iterator iter = photoSets.iterator();
        while (iter.hasNext()) {
            PhotoSet set = (PhotoSet)iter.next();
            if (!set.isNew()) continue;
            rv.add(set);
        }
        return rv;
    }

    public void execute() {
        Iterator iter = this.sets.iterator();
        while (iter.hasNext()) {
            PhotoSet set = (PhotoSet)iter.next();
            this.photoSetName = set.getTitle();
            this.updateMessage();
            CreatePhotoSet create = new CreatePhotoSet(set);
            if (this.api.executeMethod(create)) {
                set.setNew(false);
            } else if (create.getErrorCode() == 3) {
                MessageUtils.showErrorMessage((String)create.getResponseHandler().getFailureReason());
                break;
            }
            this.updateProgress(this.current++);
        }
    }

    public String getMessage() {
        return Messages.getString((String)"juploadr.ui.task.createphotsets.creating") + this.photoSetName + " (" + this.current + "/" + this.sets.size() + ")";
    }
}

