/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.zooomr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.eclipse.swt.widgets.Decorations;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.event.UploadCompleteEvent;
import org.scohen.juploadr.event.UploadStatusMonitor;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.PopupHandler;
import org.scohen.juploadr.ui.ProgressDialog;
import org.scohen.juploadr.ui.Task;
import org.scohen.juploadr.uploadapi.Account;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ImageUploadApi;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.UploadFailedException;
import org.scohen.juploadr.uploadapi.zooomr.AddToPhotosetTask;
import org.scohen.juploadr.uploadapi.zooomr.CreateAllPhotosetsTask;
import org.scohen.juploadr.uploadapi.zooomr.Messages;
import org.scohen.juploadr.uploadapi.zooomr.PostUploadAction;
import org.scohen.juploadr.uploadapi.zooomr.RotateTask;
import org.scohen.juploadr.uploadapi.zooomr.ZooomrMethod;
import org.scohen.juploadr.uploadapi.zooomr.authentication.ZooomrAccount;
import org.scohen.juploadr.uploadapi.zooomr.authentication.ZooomrAuthEventDirector;
import org.scohen.juploadr.uploadapi.zooomr.photosets.GetPhotosetList;
import org.scohen.juploadr.uploadapi.zooomr.tags.GetListUser;
import org.scohen.juploadr.uploadapi.zooomr.ui.ZooomrPopupHandler;
import org.scohen.juploadr.uploadapi.zooomr.upload.ZooomrUpload;
import org.scohen.juploadr.util.NonNullList;

public class ZooomrRestApi
extends ImageUploadApi {
    public static final String ZOOOMR_SHARED_SECRET = "fb2377b77bd2639c";
    public static final String ZOOOMR_API_KEY = "6dd0b757dc9013189d2f250d0385320dc7f291d7";
    private Class[] configClasses = new Class[]{class$org$scohen$juploadr$uploadapi$zooomr$ui$ZoomrAccountForm == null ? (class$org$scohen$juploadr$uploadapi$zooomr$ui$ZoomrAccountForm = ZooomrRestApi.class$("org.scohen.juploadr.uploadapi.zooomr.ui.ZoomrAccountForm")) : class$org$scohen$juploadr$uploadapi$zooomr$ui$ZoomrAccountForm, class$org$scohen$juploadr$uploadapi$zooomr$ui$ZooomrMetadataForm == null ? (class$org$scohen$juploadr$uploadapi$zooomr$ui$ZooomrMetadataForm = ZooomrRestApi.class$("org.scohen.juploadr.uploadapi.zooomr.ui.ZooomrMetadataForm")) : class$org$scohen$juploadr$uploadapi$zooomr$ui$ZooomrMetadataForm};
    private static NonNullList photoSets = new NonNullList();
    private static Map unfinishedActions = new HashMap();
    private static ZooomrAccount currentAccount;
    private static final String DEFAULT_ACCOUNT_KEY;
    private static Preferences prefs;
    private static ZooomrRestApi instance;
    static /* synthetic */ Class class$org$scohen$juploadr$uploadapi$zooomr$ui$ZoomrAccountForm;
    static /* synthetic */ Class class$org$scohen$juploadr$uploadapi$zooomr$ui$ZooomrMetadataForm;
    static /* synthetic */ Class class$org$scohen$juploadr$uploadapi$zooomr$ZooomrRestApi;
    static /* synthetic */ Class class$org$scohen$juploadr$uploadapi$zooomr$authentication$ZooomrAccount;

    public static synchronized ImageUploadApi getInstance() {
        return instance;
    }

    public String getSiteName() {
        return "Zooomr";
    }

    public void upload(UploadImage imageAttributes, UploadStatusMonitor monitor) throws UploadFailedException, CommunicationException {
        if (!this.isCurrentAccountAuthenticated()) {
            try {
                this.authenticate(this.getCurrentAccount());
            }
            catch (ProtocolException e) {
                throw new UploadFailedException(e.getMessage(), (Throwable)e);
            }
        }
        ZooomrUpload flickrUpload = new ZooomrUpload(imageAttributes, monitor);
        try {
            flickrUpload.execute();
        }
        catch (ProtocolException e) {
            throw new UploadFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public Account getCurrentAccount() {
        if (currentAccount == null) {
            Map accounts = ZooomrAccount.allAccounts();
            if (currentAccount == null) {
                currentAccount = ZooomrAccount.getNullAccount();
            }
            if (accounts.size() > 0 && accounts.get(prefs.get(DEFAULT_ACCOUNT_KEY, "")) != null) {
                currentAccount = (ZooomrAccount)((Object)accounts.get(prefs.get(DEFAULT_ACCOUNT_KEY, "")));
            }
        }
        return currentAccount;
    }

    public Account newAccount(String name) {
        return new ZooomrAccount(name);
    }

    public void setCurrentAccount(Account account) {
        if (account != null && !(account instanceof ZooomrAccount)) {
            Object[] args = new Object[]{account.getClass().getName(), (class$org$scohen$juploadr$uploadapi$zooomr$authentication$ZooomrAccount == null ? (class$org$scohen$juploadr$uploadapi$zooomr$authentication$ZooomrAccount = ZooomrRestApi.class$("org.scohen.juploadr.uploadapi.zooomr.authentication.ZooomrAccount")) : class$org$scohen$juploadr$uploadapi$zooomr$authentication$ZooomrAccount).getName()};
            throw new IllegalArgumentException(Messages.getString("juploadr.zooomr.account.type.incorrect", args));
        }
        currentAccount = (ZooomrAccount)account;
        if (currentAccount.getUsername() != null) {
            prefs.put(DEFAULT_ACCOUNT_KEY, currentAccount.getUsername());
        }
    }

    public boolean isCurrentAccountNullAccount() {
        return this.getCurrentAccount().equals((Object)ZooomrAccount.getNullAccount());
    }

    public List allAccounts() {
        return new LinkedList(ZooomrAccount.allAccounts().values());
    }

    public boolean authenticate(Account account) throws ProtocolException, CommunicationException {
        ZooomrAuthEventDirector eventDirector = new ZooomrAuthEventDirector();
        return eventDirector.execute((ZooomrAccount)account);
    }

    public void initialize() {
        if (this.isCurrentAccountAuthenticated()) {
            Thread getPhotoSets = new Thread(){

                public void run() {
                    GetPhotosetList getList = new GetPhotosetList();
                    ZooomrRestApi.this.executeMethod(getList);
                }
            };
            Thread getTags = new Thread(){

                public void run() {
                    GetListUser tags = new GetListUser();
                    ZooomrRestApi.this.executeMethod(tags);
                    ZooomrRestApi.this.getCurrentAccount().setUserTags(tags.getTags());
                }
            };
            getPhotoSets.start();
            getTags.start();
        }
    }

    public Class[] getConfiurationDialogs() {
        return this.configClasses;
    }

    public PopupHandler windowRightClicked(Decorations parent, JUploadr clicked) {
        return new ZooomrPopupHandler(parent, clicked);
    }

    public PopupHandler thumbnailRightClicked(Decorations parent, JUploadr uploadr, ImageAttributes clicked) {
        if (!clicked.isSelected()) {
            Collection allAttributes = uploadr.getImageAttributes().values();
            Iterator iter = allAttributes.iterator();
            while (iter.hasNext()) {
                ImageAttributes atts = (ImageAttributes)iter.next();
                atts.setSelected(atts.equals(clicked));
            }
        }
        uploadr.refresh();
        return new ZooomrPopupHandler(parent, uploadr);
    }

    public static void setPhotoSets(List sets) {
        photoSets = sets instanceof NonNullList ? (NonNullList)sets : new NonNullList(sets);
    }

    public static void addPhotoSet(PhotoSet set) {
        photoSets.add((Object)set);
        Collections.sort(photoSets);
    }

    public void postProcessUpload(UploadCompleteEvent e, ImageAttributes atts) {
        atts.setPhotoId(e.getResponse().getPhotoId());
    }

    public void postProcessAllUploads(Collection images) {
        AddToPhotosetTask addTask;
        ProgressDialog pd;
        CreateAllPhotosetsTask createTask = new CreateAllPhotosetsTask((Collection)photoSets, this);
        if (createTask.hasSetsToCreate()) {
            pd = new ProgressDialog(JUploadr.window, (Task)createTask);
            pd.execute();
        }
        if ((addTask = new AddToPhotosetTask((Collection)photoSets, this)).hasSetsToAdd()) {
            pd = new ProgressDialog(JUploadr.window, (Task)addTask);
            pd.execute();
        }
        this.rotateImages(images);
        GetPhotosetList getPhotoSets = new GetPhotosetList();
        this.executeMethod(getPhotoSets);
        while (unfinishedActions.size() > 0 && this.showUnfinishedUploadErrorMessage()) {
            this.retryUnfinishedActions();
        }
        photoSets.clear();
        GetPhotosetList getList = new GetPhotosetList();
        this.executeMethod(getList);
        photoSets = new NonNullList(getList.getPhotoSets());
    }

    private void retryUnfinishedActions() {
        LinkedList actions = new LinkedList();
        Iterator<Object> iter = unfinishedActions.values().iterator();
        while (iter.hasNext()) {
            List next = (List)iter.next();
            actions.addAll(next);
        }
        unfinishedActions.clear();
        iter = actions.iterator();
        while (iter.hasNext()) {
            ZooomrMethod method = (ZooomrMethod)iter.next();
            this.executeMethod(method);
        }
    }

    private boolean showUnfinishedUploadErrorMessage() {
        StringBuffer errorMessage = new StringBuffer();
        errorMessage.append(Messages.getString("juploadr.zooomr.error.after.upload"));
        Iterator failureClasses = unfinishedActions.keySet().iterator();
        while (failureClasses.hasNext()) {
            List actions = this.getFailedActions((Class)failureClasses.next());
            if (actions == null) continue;
            Iterator actionIter = actions.iterator();
            while (actionIter.hasNext()) {
                PostUploadAction method = (PostUploadAction)actionIter.next();
                errorMessage.append(Messages.getString("juploadr.zooomr.failed.to"));
                errorMessage.append(method.getErrorText());
                errorMessage.append("\n");
            }
        }
        errorMessage.append(Messages.getString("juploadr.zooomr.option.retry"));
        return MessageUtils.showMessage((String)errorMessage.toString(), (String)Messages.getString("juploadr.zooomr.actions.failed"), (int)200);
    }

    private void rotateImages(Collection images) {
        Collection coll = this.getImagesToRotate(images);
        if (coll.size() > 0) {
            RotateTask rt = new RotateTask(coll, this);
            ProgressDialog pd = new ProgressDialog(JUploadr.window, (Task)rt);
            pd.execute();
        }
    }

    private void addFailedAction(PostUploadAction failed) {
        LinkedList<PostUploadAction> failedActions = (LinkedList<PostUploadAction>)unfinishedActions.get(failed.getClass());
        if (failedActions == null) {
            failedActions = new LinkedList<PostUploadAction>();
        }
        if (!failedActions.contains(failed)) {
            failedActions.add(failed);
        }
        unfinishedActions.put(failed.getClass(), failedActions);
    }

    private List getFailedActions(Class clazz) {
        return (List)unfinishedActions.get(clazz);
    }

    private Collection getImagesToRotate(Collection allImages) {
        LinkedList<UploadImage> images = new LinkedList<UploadImage>();
        Iterator iter = allImages.iterator();
        while (iter.hasNext()) {
            UploadImage image = (UploadImage)iter.next();
            if (image.getRotation() == 0) continue;
            images.add(image);
        }
        return images;
    }

    public boolean executeMethod(ZooomrMethod method) {
        try {
            method.execute();
            return true;
        }
        catch (ProtocolException e) {
        }
        catch (CommunicationException communicationException) {
            // empty catch block
        }
        if (method instanceof PostUploadAction) {
            this.addFailedAction((PostUploadAction)((Object)method));
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_ACCOUNT_KEY = (class$org$scohen$juploadr$uploadapi$zooomr$ZooomrRestApi == null ? (class$org$scohen$juploadr$uploadapi$zooomr$ZooomrRestApi = ZooomrRestApi.class$("org.scohen.juploadr.uploadapi.zooomr.ZooomrRestApi")) : class$org$scohen$juploadr$uploadapi$zooomr$ZooomrRestApi).getName() + ".defaultAccount";
        prefs = Preferences.userNodeForPackage(class$org$scohen$juploadr$uploadapi$zooomr$ZooomrRestApi == null ? (class$org$scohen$juploadr$uploadapi$zooomr$ZooomrRestApi = ZooomrRestApi.class$("org.scohen.juploadr.uploadapi.zooomr.ZooomrRestApi")) : class$org$scohen$juploadr$uploadapi$zooomr$ZooomrRestApi);
        instance = new ZooomrRestApi();
    }
}

