/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.Task;
import org.scohen.juploadr.uploadapi.flickrrest.RestFlickrApi;
import org.scohen.juploadr.uploadapi.flickrrest.photosets.CreatePhotoSet;

public class CreateAllPhotosetsTask
extends Task {
    private Collection sets;
    private RestFlickrApi api;
    private String photoSetName;
    private int current;

    public CreateAllPhotosetsTask(Collection photoSets, RestFlickrApi api) {
        this.sets = this.getNewPhotoSets(photoSets);
        this.api = api;
        this.max = this.sets.size();
        this.min = 0;
    }

    public String getTitle() {
        Object[] args = new Object[]{new Integer(this.max)};
        return Messages.getString((String)"juploadr.ui.task.createphotsets.creating.title", (Object[])args);
    }

    public boolean hasSetsToCreate() {
        return this.sets.size() > 0;
    }

    private Collection getNewPhotoSets(Collection photoSets) {
        LinkedList<PhotoSet> rv = new LinkedList<PhotoSet>();
        Iterator iter = photoSets.iterator();
        while (iter.hasNext()) {
            PhotoSet set = (PhotoSet)iter.next();
            if (!set.isNew()) continue;
            rv.add(set);
        }
        return rv;
    }

    public void execute() {
        Iterator iter = this.sets.iterator();
        while (iter.hasNext()) {
            PhotoSet set = (PhotoSet)iter.next();
            this.photoSetName = set.getTitle();
            this.updateMessage();
            CreatePhotoSet create = new CreatePhotoSet(set);
            if (this.api.executeMethod(create)) {
                set.setNew(false);
            } else if (create.getErrorCode() == 3) {
                MessageUtils.showErrorMessage((String)create.getResponseHandler().getFailureReason());
                break;
            }
            this.updateProgress(this.current++);
        }
    }

    public String getMessage() {
        Object[] args = new Object[]{this.photoSetName, new Integer(this.current), new Integer(this.max)};
        return Messages.getString((String)"juploadr.ui.task.createphotsets.creating", (Object[])args);
    }
}

