/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest.transform;

import java.util.SortedMap;
import java.util.TreeMap;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.flickrrest.DefaultFlickrHandler;
import org.scohen.juploadr.uploadapi.flickrrest.FlickrMethod;
import org.scohen.juploadr.uploadapi.flickrrest.PostUploadAction;

public class Rotate
extends FlickrMethod
implements PostUploadAction {
    private String photoId;
    private int degrees;
    private UploadImage image;

    public Rotate(UploadImage img) {
        this.photoId = img.getPhotoId();
        this.degrees = img.getRotation() % 360;
        this.image = img;
    }

    public DefaultFlickrHandler getResponseHandler() {
        return new NullFlickrHandler(this);
    }

    public SortedMap getParams() {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("api_key", "1892f5f9d32f01b86f53b50cdac89c8c");
        params.put("method", "flickr.photos.transform.rotate");
        params.put("photo_id", this.photoId);
        params.put("degrees", String.valueOf(this.degrees));
        return params;
    }

    public boolean isAuthorized() {
        return true;
    }

    public boolean execute() throws ProtocolException, CommunicationException {
        if (this.degrees != 0) {
            return super.execute();
        }
        return true;
    }

    public UploadImage getImage() {
        return this.image;
    }

    public String getErrorText() {
        return "rotate " + this.image.getTitle();
    }

    private class NullFlickrHandler
    extends DefaultFlickrHandler {
        public NullFlickrHandler(Object parent) {
            super(parent);
        }
    }
}

