/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.flickrrest.ui;

import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.tags.TagParser;
import org.scohen.juploadr.prefs.BaseConfigurationForm;
import org.scohen.juploadr.prefs.Fault;
import org.scohen.juploadr.uploadapi.Account;

public class MetadataForm
extends BaseConfigurationForm {
    private Label tagsLabel;
    private Group privacyComposite;
    private Button radioPublic;
    private Button radioPrivate;
    private Button friends;
    private Button family;
    private Composite privacyOptions;
    private Text defaultTags;

    public MetadataForm(Composite parent) {
        super(parent);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                MetadataForm.this.disposed(event);
            }
        });
    }

    protected void initUI() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        GridData data = new GridData(768);
        SelectionAdapter radioSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetadataForm.this.radioClicked(e);
            }
        };
        this.privacyComposite = new Group((Composite)this, 32);
        layout = new GridLayout();
        layout.numColumns = 2;
        this.privacyComposite.setLayout((Layout)layout);
        this.privacyComposite.setText(Messages.getString((String)"juploadr.ui.dialog.label.default.privacy"));
        this.privacyComposite.setLayoutData((Object)data);
        this.radioPrivate = new Button((Composite)this.privacyComposite, 16);
        this.radioPrivate.setText(Messages.getString((String)"juploadr.ui.label.private"));
        this.radioPrivate.setLayoutData((Object)new GridData(768));
        this.radioPrivate.addSelectionListener((SelectionListener)radioSelectionListener);
        this.radioPublic = new Button((Composite)this.privacyComposite, 16);
        this.radioPublic.setText(Messages.getString((String)"juploadr.ui.label.public"));
        this.radioPublic.setLayoutData((Object)new GridData(768));
        this.radioPublic.addSelectionListener((SelectionListener)radioSelectionListener);
        this.privacyOptions = new Composite((Composite)this.privacyComposite, 16);
        this.privacyOptions.setLayoutData((Object)new GridData(768));
        this.privacyOptions.setLayout((Layout)new FillLayout());
        this.friends = new Button(this.privacyOptions, 32);
        this.friends.setText(Messages.getString((String)"juploadr.ui.label.friends"));
        this.family = new Button(this.privacyOptions, 32);
        this.family.setText(Messages.getString((String)"juploadr.ui.label.family"));
        Account currentAccount = this.api.getCurrentAccount();
        if ((2 & currentAccount.getDefaultPrivacySetting()) != 0) {
            this.radioPrivate.setSelection(true);
        } else {
            this.radioPublic.setSelection(true);
            this.friends.setEnabled(false);
            this.family.setEnabled(false);
        }
        if ((currentAccount.getDefaultPrivacySetting() & 8) != 0) {
            this.family.setSelection(true);
        }
        if ((currentAccount.getDefaultPrivacySetting() & 4) != 0) {
            this.friends.setSelection(true);
        }
        this.tagsLabel = new Label((Composite)this, 0);
        this.tagsLabel.setText(Messages.getString((String)"juploadr.ui.dialog.label.default.tags"));
        layout = new GridLayout();
        layout.numColumns = 2;
        this.defaultTags = new Text((Composite)this, 2114);
        this.defaultTags.setText(TagParser.toInputString((List)currentAccount.getDefaultTags()));
        data = new GridData(1808);
        this.defaultTags.setLayoutData((Object)data);
    }

    private void disposed(DisposeEvent event) {
        this.radioPrivate.dispose();
        this.radioPublic.dispose();
        this.privacyComposite.dispose();
        this.tagsLabel.dispose();
        this.defaultTags.dispose();
    }

    public void saveChanges() {
        Account account = this.api.getCurrentAccount();
        account.setDefaultTags(TagParser.parse((String)this.defaultTags.getText()));
        int privacySetting = 0;
        if (this.friends.getSelection()) {
            privacySetting |= 4;
        }
        if (this.family.getSelection()) {
            privacySetting |= 8;
        }
        privacySetting = this.radioPrivate.getSelection() ? (privacySetting |= 2) : 1;
        account.setDefaultPrivacySetting(privacySetting);
        account.save();
    }

    public Fault validateChanges() {
        return null;
    }

    public String getFormName() {
        return Messages.getString((String)"juploadr.ui.dialog.metadataform.title");
    }

    private void radioClicked(SelectionEvent event) {
        this.friends.setEnabled(this.radioPrivate == event.widget);
        this.family.setEnabled(this.radioPrivate == event.widget);
    }

    public void accountChanged() {
        this.resetUI();
        this.initUI();
        this.layout();
    }
}

