/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.zooomr.authentication;

import org.eclipse.swt.widgets.Shell;
import org.scohen.juploadr.app.authentication.AuthorizationDialog;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.uploadapi.Account;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ImageUploadApi;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.zooomr.Messages;
import org.scohen.juploadr.uploadapi.zooomr.StringSigner;
import org.scohen.juploadr.uploadapi.zooomr.ZooomrRestApi;
import org.scohen.juploadr.uploadapi.zooomr.authentication.GetFrob;
import org.scohen.juploadr.uploadapi.zooomr.authentication.GetToken;
import org.scohen.juploadr.uploadapi.zooomr.authentication.ZooomrAccount;
import org.scohen.juploadr.uploadapi.zooomr.upload.GetUploadStatus;
import org.scohen.juploadr.util.JUploadrBrowserLauncher;

public class ZooomrAuthEventDirector {
    private static final String PERMS = "write";
    private static final String LINK_BASE = "http://beta.zooomr.com/auth/?api_key=6dd0b757dc9013189d2f250d0385320dc7f291d7&perms=write";
    private String frob;

    public boolean execute(ZooomrAccount info) throws ProtocolException, CommunicationException {
        ZooomrRestApi api = (ZooomrRestApi)ZooomrRestApi.getInstance();
        if (!info.isAuthenticated()) {
            GetFrob getFrob = new GetFrob();
            getFrob.execute();
            this.frob = getFrob.getFrob();
            info.setFrob(this.frob);
            Shell shell = ReusableUIFactory.getInstance().getDisplay().getActiveShell();
            AuthorizationDialog authDialog = new AuthorizationDialog(Messages.getString("juploadr.zooomr.authdialog.line1"), Messages.getString("juploadr.zooomr.authdialog.line2"), Messages.getString("juploadr.zooomr.authdialog.line3"), Messages.getString("juploadr.zooomr.button.authorize"), shell);
            boolean shouldAuth = authDialog.open();
            if (shouldAuth) {
                String authLink = this.buildAuthLink();
                JUploadrBrowserLauncher.openURL((String)authLink, (String)Messages.getString("juploadr.zooomr.authdialog.browser.not.found"));
                AuthorizationDialog continueDialog = new AuthorizationDialog(Messages.getString("juploadr.zooomr.continuedialog.line1"), Messages.getString("juploadr.zooomr.continuedialog.line2"), Messages.getString("juploadr.zooomr.continuedialog.line3"), Messages.getString("juploadr.zooomr.button.complete-auth"), shell);
                if (continueDialog.open()) {
                    GetToken getToken = new GetToken(this.frob);
                    getToken.execute();
                    info.setToken(getToken.getToken());
                    info.setAuthenticated(getToken.getToken() != null);
                    api.setCurrentAccount(info);
                } else {
                    return false;
                }
            }
        }
        if (ImageUploadApi.getInstance().isCurrentAccountAuthenticated()) {
            GetUploadStatus gus = new GetUploadStatus();
            gus.execute();
            info.configureFrom(gus);
            info.save();
            ImageUploadApi.getInstance().setCurrentAccount((Account)info);
            ImageUploadApi.getInstance().initialize();
        }
        return true;
    }

    private String buildAuthLink() {
        StringBuffer link = new StringBuffer(LINK_BASE);
        link.append("&frob=");
        link.append(this.frob);
        link.append("&api_sig=");
        StringBuffer apiSig = new StringBuffer("fb2377b77bd2639c");
        apiSig.append("api_key");
        apiSig.append("6dd0b757dc9013189d2f250d0385320dc7f291d7");
        apiSig.append("frob");
        apiSig.append(this.frob);
        apiSig.append("perms");
        apiSig.append(PERMS);
        link.append(StringSigner.md5(apiSig.toString()));
        return link.toString();
    }
}

