/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi.zooomr.ui;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.uploadapi.flickrrest.RestFlickrApi;
import org.scohen.juploadr.uploadapi.flickrrest.photosets.FlickrPhotoSet;

public class NewPhotoSetDialog
extends Dialog {
    private Button btnOk;
    private Button btnCancel;
    private Label lblDescription;
    private Label lblTitle;
    private Text txtDescription;
    private Text txtTitle;
    private Composite buttons;
    private Shell shell;
    private ImageAttributes primary;
    private List photosToAdd;

    public NewPhotoSetDialog(Shell shell, ImageAttributes primary) {
        super(shell);
        this.primary = primary;
    }

    public NewPhotoSetDialog(Shell window, List toAdd) {
        this(window, (ImageAttributes)toAdd.remove(0));
        this.photosToAdd = toAdd;
    }

    public void open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67680);
        this.shell.setText(org.scohen.juploadr.uploadapi.flickrrest.Messages.getString((String)"juploadr.flickrrest.ui.photoset.create.new"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GC gc = new GC((Drawable)this.shell);
        int txtFieldWidth = gc.textExtent((String)"B").x * 40;
        int txtFieldHeight = gc.textExtent((String)"B").y * 5;
        gc.dispose();
        this.shell.setLayout((Layout)layout);
        this.lblTitle = new Label((Composite)this.shell, 256);
        this.lblTitle.setText(org.scohen.juploadr.uploadapi.flickrrest.Messages.getString((String)"juploadr.flickrrest.ui.photoset.title"));
        GridData data = this.getTextLayoutData();
        data.verticalAlignment = 0x1000000;
        this.lblTitle.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.txtTitle = new Text((Composite)this.shell, 2048);
        this.txtTitle.setLayoutData((Object)data);
        this.lblDescription = new Label((Composite)this.shell, 256);
        this.lblDescription.setText(org.scohen.juploadr.uploadapi.flickrrest.Messages.getString((String)"juploadr.flickrrest.ui.photoset.description"));
        this.lblDescription.setLayoutData((Object)this.getTextLayoutData());
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = txtFieldHeight;
        data.widthHint = txtFieldWidth;
        this.txtDescription = new Text((Composite)this.shell, 2114);
        this.txtDescription.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.buttons = new Composite((Composite)this.shell, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.spacing = 0;
        this.buttons.setLayout((Layout)fillLayout);
        data.horizontalAlignment = 3;
        data.horizontalIndent = 0;
        this.buttons.setLayoutData((Object)data);
        this.btnOk = new Button(this.buttons, 8);
        this.btnOk.setText(Messages.getString((String)"juploadr.ui.button.ok"));
        this.btnOk.setSelection(true);
        this.btnCancel = new Button(this.buttons, 8);
        this.btnCancel.setText(Messages.getString((String)"juploadr.ui.button.cancel"));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPhotoSetDialog.this.buttonClicked(e);
            }
        };
        this.btnOk.addSelectionListener((SelectionListener)listener);
        this.btnCancel.addSelectionListener((SelectionListener)listener);
        this.shell.setDefaultButton(this.btnOk);
        this.shell.pack();
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private GridData getTextLayoutData() {
        GridData data = new GridData();
        data.verticalIndent = 5;
        data.verticalAlignment = 128;
        this.lblTitle.setLayoutData((Object)data);
        return data;
    }

    protected void buttonClicked(SelectionEvent event) {
        if (event.widget == this.btnOk) {
            if (this.txtTitle.getText() == null || this.txtTitle.getText().trim().length() == 0) {
                MessageUtils.showErrorMessage((String)org.scohen.juploadr.uploadapi.flickrrest.Messages.getString((String)"juploadr.flickrrest.ui.photoset.error.title.required"));
            } else {
                FlickrPhotoSet set = new FlickrPhotoSet();
                set.setDescription(this.txtDescription.getText());
                set.setNew(true);
                set.setPrimaryPhoto(this.primary);
                set.setTitle(this.txtTitle.getText());
                set.addPhoto(this.primary);
                if (this.photosToAdd != null && this.photosToAdd.size() > 0) {
                    for (int i = 0; i < this.photosToAdd.size(); ++i) {
                        set.addPhoto((ImageAttributes)this.photosToAdd.get(i));
                    }
                }
                RestFlickrApi.addPhotoSet((PhotoSet)set);
                this.shell.dispose();
            }
        } else {
            this.shell.dispose();
        }
    }
}

