/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.scohen.juploadr.app.ImageAttributesUI;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.PhotoSet;
import org.scohen.juploadr.app.RescaleThread;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.event.RescaleListener;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.thumbnail.Thumbnail;
import org.scohen.juploadr.ui.thumbnail.ThumbnailFactory;
import org.scohen.juploadr.ui.thumbnail.UploadThumbnail;
import org.scohen.juploadr.uploadapi.Account;
import org.scohen.juploadr.uploadapi.ImageUploadApi;

public class ImageAttributes
implements UploadImage {
    public static final int UI_THUMBNAIL_WIDTH = 250;
    private static final int THUMBNAIL_WIDTH = 96;
    private static final int THUMBNAIL_HEIGHT = 96;
    private JUploadr uploader;
    private int rank;
    private volatile Display parent;
    private Composite buttonList;
    private int state = 0;
    private Image buttonImage;
    private volatile Image thumbnail;
    private String imagePath;
    private String description;
    private String title;
    private List tags;
    private Thumbnail button;
    private boolean publiclyVisible;
    private boolean friendViewable;
    private boolean familyViewable;
    private boolean selected = false;
    private String key;
    private ReusableUIFactory uiFactory;
    private List photoSets;
    private String photoId;
    private int rotation;
    private Pattern extension = Pattern.compile("([^\\.]+)(\\.\\w{1,4})+$");

    public ImageAttributes(JUploadr uploader, Composite parent, String path) {
        this.photoSets = new ArrayList();
        this.uiFactory = ReusableUIFactory.getInstance();
        this.uploader = uploader;
        Account current = ImageUploadApi.getInstance().getCurrentAccount();
        this.publiclyVisible = (1 & current.getDefaultPrivacySetting()) != 0;
        if ((4 & current.getDefaultPrivacySetting()) != 0) {
            this.friendViewable = true;
        }
        if ((8 & current.getDefaultPrivacySetting()) != 0) {
            this.familyViewable = true;
        }
        this.tags = new LinkedList(current.getDefaultTags());
        this.title = path.substring(path.lastIndexOf(File.separator) + 1);
        Matcher matcher = this.extension.matcher(this.title);
        if (matcher.matches()) {
            this.title = matcher.group(1);
        }
        this.key = this.imagePath = path;
        this.buttonList = parent;
        this.parent = parent.getDisplay();
        this.button = ThumbnailFactory.newThumbnail(parent, this, 0x800008);
        this.button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                ImageAttributes.this.mouseDoubleClick(event);
            }

            public void mouseDown(MouseEvent event) {
                ImageAttributes.this.mouseDown(event);
            }
        });
        this.thumbnail = this.generateThumbnail(parent.getDisplay());
        ImageData thumbnailData = this.thumbnail.getImageData();
        this.generateButtonImage(parent.getDisplay(), thumbnailData);
    }

    private void generateButtonImage(Display display, ImageData thumbnailData) {
        this.buttonImage = new Image((Device)display, 96, 96);
        GC gfx = new GC((Drawable)this.buttonImage);
        int smallerSide = Math.min(thumbnailData.width, thumbnailData.height);
        gfx.drawImage(this.thumbnail, 0, 0, smallerSide, smallerSide, 0, 0, 96, 96);
        this.button.setImage(this.buttonImage);
        gfx.dispose();
    }

    private Image generateThumbnail(Display display) {
        RescaleListener listener = new RescaleListener(){

            public void rescaleDone(Image thumb) {
                Runnable r = new Runnable(this, thumb){
                    private final /* synthetic */ Image val$thumb;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$thumb = val$thumb;
                    }

                    public void run() {
                        ImageAttributes.access$302(2.access$200(this.this$1), this.val$thumb);
                        ImageAttributes.access$500(2.access$200(this.this$1), ImageAttributes.access$400(2.access$200(this.this$1)), this.val$thumb.getImageData());
                        2.access$200(this.this$1).getButton().redraw();
                    }
                };
                ImageAttributes.this.parent.syncExec(r);
            }

            public void rescaleFailed(String message) {
                Runnable r = new Runnable(this, message){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$message = val$message;
                    }

                    public void run() {
                        MessageUtils.showErrorMessage(this.val$message);
                        2.access$200(this.this$1).removeFromWindow();
                    }
                };
                ImageAttributes.this.parent.syncExec(r);
            }

            static /* synthetic */ ImageAttributes access$200(2 x0) {
                return x0.ImageAttributes.this;
            }
        };
        RescaleThread.addImage(this.getImagePath(), listener);
        return this.uiFactory.getUnknownImage();
    }

    private void mouseDoubleClick(MouseEvent arg0) {
        this.openEditUI();
    }

    public void keyPressed(KeyEvent event) {
        if (event.character == '\u007f' || event.keyCode == 8) {
            Iterator iter = this.uploader.getImageAttributes().values().iterator();
            while (iter.hasNext()) {
                ImageAttributes atts = (ImageAttributes)iter.next();
                if (!atts.isSelected()) continue;
                iter.remove();
                atts.removeFromWindow();
            }
        }
    }

    private void mouseDown(MouseEvent event) {
        if (event.button == 1 && event.stateMask != 262144) {
            this.toggleSelected();
            this.button.redraw();
        }
    }

    public void openEditUI() {
        ImageAttributesUI attrUI = new ImageAttributesUI(this);
        attrUI.show(this.parent);
        if (!attrUI.isCancelled()) {
            this.state = 2;
        }
    }

    public Thumbnail getButton() {
        return this.button;
    }

    public void setButton(UploadThumbnail button) {
        this.button = button;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && this.description.trim().length() > 0;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List getTags() {
        return this.tags;
    }

    public boolean hasTags() {
        return this.tags.size() > 0;
    }

    public void setTags(List tags) {
        this.tags = tags;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return this.title != null && this.title.length() > 0 && !this.imagePath.endsWith(this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isRescaled() {
        return false;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        if (state == 1) {
            this.rank -= 100;
        }
        this.state = state;
    }

    public boolean isFamilyViewable() {
        return this.familyViewable;
    }

    public void setFamilyViewable(boolean familyViewable) {
        this.familyViewable = familyViewable;
    }

    public boolean isFriendViewable() {
        return this.friendViewable;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void toggleSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setFriendViewable(boolean friendViewable) {
        this.friendViewable = friendViewable;
    }

    public boolean isPubliclyVisible() {
        return this.publiclyVisible;
    }

    public void setPubliclyVisible(boolean publiclyVisible) {
        this.publiclyVisible = publiclyVisible;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void dispose() {
    }

    public void removeFromWindow() {
        this.state = 4;
        List photoSets = this.getPhotoSets();
        Iterator iter = photoSets.iterator();
        while (iter.hasNext()) {
            PhotoSet set = (PhotoSet)iter.next();
            iter.remove();
            set.removePhoto(this);
        }
        if (this.thumbnail != this.uiFactory.getUnknownImage()) {
            this.thumbnail.dispose();
        }
        this.buttonImage.dispose();
        this.button.dispose();
        this.uploader.refresh();
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Image thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void addPhotoSet(PhotoSet set) {
        this.photoSets.add(set);
    }

    public List getPhotoSets() {
        return this.photoSets;
    }

    public void setPhotoId(String id) {
        this.photoId = id;
    }

    public String getPhotoId() {
        return this.photoId;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    static /* synthetic */ Image access$302(ImageAttributes x0, Image x1) {
        x0.thumbnail = x1;
        return x0.thumbnail;
    }

    static /* synthetic */ void access$500(ImageAttributes x0, Display x1, ImageData x2) {
        x0.generateButtonImage(x1, x2);
    }
}

