/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app;

import java.io.File;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.tags.TagParser;
import org.scohen.juploadr.app.tags.TagsHelper;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.Transforms;

public class ImageAttributesUI
implements SelectionListener {
    protected Shell window;
    protected Text txtTags;
    protected Text txtTitle;
    protected Text txtDescription;
    private Button btnOK;
    private Button btnCancel;
    private Image thumbnail;
    private boolean cancelled = false;
    private ImageAttributes attrs;
    protected Button radioPrivate;
    protected Button radioPublic;
    protected Button checkFriends;
    protected Button checkFamily;
    protected Button rotateLeft;
    protected Button rotateRight;
    protected Composite rotateButtons;
    protected Composite thumbnailComposite;
    private int originalRotation;
    private ReusableUIFactory uiFactory = ReusableUIFactory.getInstance();
    private TagsHelper tagHelper;
    private EscListener escListener;

    public ImageAttributesUI(ImageAttributes attrs) {
        this.thumbnail = attrs.getThumbnail();
        this.attrs = attrs;
        this.originalRotation = attrs.getRotation();
    }

    public void show(Display parent) {
        this.initUI(parent);
    }

    protected void initUI(Display display) {
        this.window = new Shell(display);
        this.window.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageAttributesUI.this.window.getDisplay().removeFilter(1, (Listener)ImageAttributesUI.this.escListener);
            }
        });
        this.window.setText(Messages.getString("juploadr.ui.imageattributes.title") + this.attrs.getTitle());
        if (!Configuration.isMac()) {
            this.window.setImage(ReusableUIFactory.getInstance().getTinyLogoImage());
        }
        GridLayout grid = new GridLayout();
        grid.makeColumnsEqualWidth = true;
        grid.numColumns = 2;
        grid.horizontalSpacing = 10;
        this.window.setLayout((Layout)grid);
        this.thumbnailComposite = new Composite((Composite)this.window, 0);
        this.addThumbnails(this.thumbnailComposite);
        GridData tnData = new GridData();
        tnData.horizontalAlignment = 4;
        tnData.verticalAlignment = 4;
        tnData.widthHint = this.thumbnail.getImageData().width;
        tnData.heightHint = this.thumbnail.getImageData().height;
        this.thumbnailComposite.setLayoutData((Object)tnData);
        Composite fields = new Composite((Composite)this.window, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        fields.setLayout((Layout)gridLayout);
        this.getLabel(fields, Messages.getString("juploadr.ui.label.privacy"));
        this.radioPrivate = new Button(fields, 16);
        this.radioPrivate.setText(Messages.getString("juploadr.ui.label.private"));
        this.radioPrivate.addSelectionListener((SelectionListener)this);
        this.getLabel(fields, "");
        this.getCheckBoxes(fields);
        this.getLabel(fields, "");
        this.radioPublic = new Button(fields, 16);
        this.radioPublic.setText(Messages.getString("juploadr.ui.label.public"));
        this.radioPublic.addSelectionListener((SelectionListener)this);
        this.getLabel(fields, Messages.getString("juploadr.ui.label.title"));
        this.txtTitle = this.getText(fields, this.attrs.getTitle());
        this.getLabel(fields, Messages.getString("juploadr.ui.label.description"));
        this.txtDescription = this.getText(fields, this.attrs.getDescription(), 2626);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 200;
        this.txtDescription.setLayoutData((Object)data);
        this.getLabel(fields, "");
        this.getLabel(fields, Messages.getString("juploadr.ui.tooltip.tags"));
        this.getLabel(fields, Messages.getString("juploadr.ui.label.tags"));
        this.txtTags = this.getText(fields, TagParser.toInputString(this.attrs.getTags()), 2626);
        this.txtTags.setToolTipText(Messages.getString("juploadr.ui.tooltip.tags"));
        data = new GridData(1808);
        data.heightHint = 50;
        data.widthHint = 200;
        this.txtTags.setLayoutData((Object)data);
        this.tagHelper = new TagsHelper();
        this.txtTags.addKeyListener((KeyListener)this.tagHelper);
        FillLayout fill = new FillLayout();
        fill.spacing = 10;
        this.rotateButtons = new Composite(fields, 0);
        this.rotateButtons.setLayout((Layout)fill);
        data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 0x1000000;
        this.rotateButtons.setLayoutData((Object)data);
        this.rotateLeft = new Button(this.rotateButtons, 8);
        this.rotateLeft.setImage(this.uiFactory.getRotateLeftImage());
        this.rotateRight = new Button(this.rotateButtons, 8);
        this.rotateRight.setImage(this.uiFactory.getRotateRightImage());
        SelectionAdapter rotateAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageAttributesUI.this.rotateClicked(event);
            }
        };
        this.rotateLeft.addSelectionListener((SelectionListener)rotateAdapter);
        this.rotateRight.addSelectionListener((SelectionListener)rotateAdapter);
        this.txtTags.addKeyListener((KeyListener)new NoTabs((Control)this.rotateLeft));
        this.txtDescription.addKeyListener((KeyListener)new NoTabs((Control)this.txtTags));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        fields.setLayoutData((Object)data);
        Composite buttons = new Composite((Composite)this.window, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.pack = false;
        buttons.setLayout((Layout)rowLayout);
        this.btnOK = new Button(buttons, 8);
        this.btnOK.setText(Messages.getString("juploadr.ui.button.ok"));
        this.btnOK.addSelectionListener((SelectionListener)this);
        this.btnOK.setSelection(true);
        this.window.setDefaultButton(this.btnOK);
        this.btnCancel = new Button(buttons, 8);
        this.btnCancel.setText(Messages.getString("juploadr.ui.button.cancel"));
        this.btnCancel.addSelectionListener((SelectionListener)this);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 2;
        buttonData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)buttonData);
        this.initDefaultValues();
        this.escListener = new EscListener();
        display.addFilter(1, (Listener)this.escListener);
        this.window.pack();
        this.window.open();
        this.window.redraw();
        while (!this.window.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.attrs.getButton().redraw();
    }

    protected void rotateClicked(SelectionEvent event) {
        if (event.widget == this.rotateLeft) {
            this.attrs.setRotation((this.attrs.getRotation() + 360 - 90) % 360);
            this.thumbnailComposite.redraw();
        } else {
            this.attrs.setRotation((this.attrs.getRotation() + 90) % 360);
            this.thumbnailComposite.redraw();
        }
    }

    protected void initDefaultValues() {
        this.radioPrivate.setSelection(!this.attrs.isPubliclyVisible());
        this.radioPublic.setSelection(this.attrs.isPubliclyVisible());
        if (this.attrs.isPubliclyVisible()) {
            this.checkFamily.setEnabled(false);
            this.checkFriends.setEnabled(false);
        }
    }

    protected void addThumbnails(Composite thumbnailComposite) {
        Canvas tnCanvas = new Canvas(thumbnailComposite, 0);
        PaintListener listener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                ImageAttributesUI.this.paintControl(event);
            }
        };
        tnCanvas.addPaintListener(listener);
        thumbnailComposite.addPaintListener(listener);
    }

    private Composite getCheckBoxes(Composite parent) {
        Composite checks = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 20;
        checks.setLayout((Layout)layout);
        this.checkFriends = new Button(checks, 32);
        this.checkFriends.setText(Messages.getString("juploadr.ui.label.visibility.friend"));
        this.checkFriends.setSelection(this.attrs.isFriendViewable());
        this.checkFamily = new Button(checks, 32);
        this.checkFamily.setText(Messages.getString("juploadr.ui.label.visibility.family"));
        this.checkFamily.setSelection(this.attrs.isFamilyViewable());
        return checks;
    }

    private Label getLabel(Composite fields, String text) {
        GridData data = new GridData();
        Label lblTitle = new Label(fields, 0);
        lblTitle.setText(text);
        GC gc = new GC((Drawable)fields);
        data.widthHint = gc.stringExtent((String)text).x;
        data.verticalAlignment = 128;
        data.verticalIndent = 5;
        gc.dispose();
        lblTitle.setLayoutData((Object)data);
        return lblTitle;
    }

    private Text getText(Composite fields, String defaultValue) {
        return this.getText(fields, defaultValue, 2048);
    }

    private Text getText(Composite fields, String defaultValue, int flags) {
        Text txt = new Text(fields, flags);
        if (defaultValue != null && defaultValue.trim().length() > 0) {
            txt.setText(defaultValue);
        }
        GridData data = new GridData(768);
        if ((flags & 2) != 0) {
            data.heightHint = 60;
        }
        txt.setLayoutData((Object)data);
        return txt;
    }

    protected void gatherData() {
        this.attrs.setTitle(this.txtTitle.getText());
        this.attrs.setDescription(this.txtDescription.getText());
        this.attrs.setTags(TagParser.parse(this.txtTags.getText()));
        if (this.radioPublic.getSelection()) {
            this.attrs.setPubliclyVisible(true);
        } else {
            this.attrs.setPubliclyVisible(false);
            this.attrs.setFamilyViewable(this.checkFamily.getSelection());
            this.attrs.setFriendViewable(this.checkFriends.getSelection());
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    private void saveAndExit() {
        this.gatherData();
        this.tagHelper.updateTags(TagParser.parse(this.txtTags.getText()));
        this.window.dispose();
    }

    public void paintControl(PaintEvent event) {
        GC gfx = event.gc;
        Image photo = this.getPhoto(event.display, this.thumbnail);
        ImageData data = photo.getImageData();
        if (this.attrs.getRotation() != 0) {
            int rotation = this.attrs.getRotation();
            ImageData newData = Transforms.rotate(data, rotation);
            photo.dispose();
            photo = new Image((Device)event.display, newData);
            data = photo.getImageData();
        }
        gfx.drawImage(photo, 0, 0);
        Color outline = new Color((Device)event.display, 205, 205, 205);
        gfx.setForeground(outline);
        gfx.drawRectangle(0, 0, data.width - 1, data.height - 1);
        photo.dispose();
        outline.dispose();
    }

    private Image getPhoto(Display disp, Image thumb) {
        ImageData data = thumb.getImageData();
        Image photo = new Image((Device)disp, data.width + 10, data.height + 10);
        GC gc = new GC((Drawable)photo);
        gc.drawImage(thumb, 5, 5);
        gc.dispose();
        return photo;
    }

    public static void main(String[] args) {
        JUploadr uploadr = new JUploadr();
        File pearPath = new File("/home/steve/pa290022sm.jpg");
        ImageAttributes atts = new ImageAttributes(uploadr, uploadr.images, pearPath.getAbsolutePath());
        ImageAttributesUI ui = new ImageAttributesUI(atts);
        ui.show(ReusableUIFactory.getInstance().getDisplay());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.btnOK) {
            this.saveAndExit();
        } else if (event.widget == this.btnCancel) {
            this.cancelled = true;
            this.attrs.setRotation(this.originalRotation);
            this.window.dispose();
        } else if (event.widget == this.radioPublic) {
            this.checkFamily.setEnabled(false);
            this.checkFriends.setEnabled(false);
        } else if (event.widget == this.radioPrivate) {
            this.checkFamily.setEnabled(true);
            this.checkFriends.setEnabled(true);
        }
    }

    private class NoTabs
    extends KeyAdapter {
        private Control next;

        public NoTabs(Control next) {
            this.next = next;
        }

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 9) {
                this.next.setFocus();
                event.doit = false;
            }
        }
    }

    private class EscListener
    implements Listener {
        private EscListener() {
        }

        public void handleEvent(Event event) {
            if (event.character == '\u001b') {
                ImageAttributesUI.this.window.dispose();
            }
        }
    }
}

