/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.ImageAttributesRankComparator;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.event.UploadCompleteEvent;
import org.scohen.juploadr.event.UploadEvent;
import org.scohen.juploadr.event.UploadStatusMonitor;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.TrayPopupHandler;
import org.scohen.juploadr.ui.thumbnail.Thumbnail;
import org.scohen.juploadr.uploadapi.Account;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ImageUploadApi;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.util.StackListDecorator;

public class JUploadrEventDirector
implements UploadStatusMonitor {
    private JUploadr juploadr;
    private ReusableUIFactory reusableUIFactory = ReusableUIFactory.getInstance();
    private List failedUploads;
    private StackListDecorator clickedOrder = new StackListDecorator(2);
    public MouseListener mouseListener = new MouseListener();
    public DropTargetListener dropTargetListener = new DropTargetListener();
    public Listener listener = new GenericListener();
    public KeyListener keyListener = new DefaultKeyListener();

    public JUploadrEventDirector(JUploadr uploader) {
        this.juploadr = uploader;
        this.failedUploads = new ArrayList();
    }

    public void uploadStarted(UploadEvent e) {
        final ProgressBar progress = this.juploadr.getProgressBar();
        final int max = (int)new File(e.getSource().getImagePath()).length();
        final String key = e.getSource().getKey();
        Runnable r = new Runnable(){

            public void run() {
                progress.setMaximum(max);
                progress.setSelection(0);
                ImageAttributes attrs = (ImageAttributes)JUploadrEventDirector.this.juploadr.getImageAttributes().get(key);
                attrs.setState(8);
                attrs.getButton().redraw();
            }
        };
        this.reusableUIFactory.getDisplay().asyncExec(r);
    }

    public void uploadStatusChanged(UploadEvent e) {
        final int uploaded = (int)e.getBytesWritten();
        final ProgressBar progress = this.juploadr.getProgressBar();
        Runnable r = new Runnable(){

            public void run() {
                progress.setSelection(uploaded);
            }
        };
        this.reusableUIFactory.getDisplay().asyncExec(r);
    }

    public void uploadFinished(UploadCompleteEvent e) {
        String key = e.getSource().getKey();
        Map imageAttributes = this.juploadr.getImageAttributes();
        if (e.getSource() != null && e.getSource().isRescaled()) {
            File rescaled = new File(e.getSource().getImagePath());
            rescaled.delete();
        }
        final ProgressBar progress = this.juploadr.getProgressBar();
        final ImageAttributes atts = (ImageAttributes)imageAttributes.get(key);
        Runnable r = new Runnable(){

            public void run() {
                progress.setSelection(progress.getMaximum());
                atts.setState(1);
                atts.getButton().redraw();
                progress.setSelection(0);
            }
        };
        ImageUploadApi.getInstance().postProcessUpload(e, atts);
        this.reusableUIFactory.getDisplay().asyncExec(r);
    }

    public void allUploadsComplete() {
        Runnable r;
        final Map imageAttributes = this.juploadr.getImageAttributes();
        if (this.failedUploads.isEmpty()) {
            r = new Runnable(){

                public void run() {
                    ImageUploadApi flickrApi = ImageUploadApi.getInstance();
                    flickrApi.postProcessAllUploads(imageAttributes.values());
                    Account userInfo = flickrApi.getCurrentAccount();
                    try {
                        flickrApi.authenticate(userInfo);
                        Account account = flickrApi.getCurrentAccount();
                        account.setMonthlyUploadLimit(userInfo.getMonthlyUploadLimit());
                        account.setCurrentUploadUsed(userInfo.getCurrentUploadUsed());
                        account.save();
                        MessageBox success = new MessageBox(JUploadr.window, 16);
                        success.setMessage(Messages.getString("juploadr.ui.message.success"));
                        success.setText(Messages.getString("juploadr.ui.message.upload.complete"));
                        success.open();
                    }
                    catch (ProtocolException e) {
                        e.printStackTrace();
                        userInfo.setAuthenticated(false);
                        userInfo.save();
                    }
                    catch (CommunicationException communicationException) {
                        // empty catch block
                    }
                }
            };
            this.reusableUIFactory.getDisplay().syncExec(r);
        } else {
            this.displayFailedUploads(imageAttributes);
        }
        if (Configuration.getInstance().getAutoRemoveUploadedPhotos()) {
            r = new Runnable(){

                public void run() {
                    JUploadrEventDirector.this.juploadr.removeUploadedPhotos();
                }
            };
            this.reusableUIFactory.getDisplay().asyncExec(r);
        }
        this.resetUploadButton();
    }

    private void displayFailedUploads(Map imageAttributes) {
        Object[] args = new Object[]{new Integer(this.failedUploads.size()), new Integer(imageAttributes.size())};
        StringBuffer errorMessage = new StringBuffer();
        errorMessage.append(Messages.getString("juploadr.ui.message.upload.failed", args));
        if (this.failedUploads.size() <= 8) {
            for (int i = 0; i < this.failedUploads.size(); ++i) {
                UploadEvent event = (UploadEvent)this.failedUploads.get(i);
                errorMessage.append(event.getSource().getImagePath());
                errorMessage.append(": \n\t");
                errorMessage.append(event.getErrorMessage());
                errorMessage.append("\n\n");
            }
        } else {
            UploadEvent event = (UploadEvent)this.failedUploads.get(0);
            errorMessage.append(event.getErrorMessage());
        }
        this.failedUploads.clear();
        final String errorText = errorMessage.toString();
        Runnable r = new Runnable(){

            public void run() {
                MessageUtils.showErrorMessage(errorText);
            }
        };
        this.reusableUIFactory.getDisplay().asyncExec(r);
    }

    private void resetUploadButton() {
        Runnable r = new Runnable(){

            public void run() {
                Button button = JUploadrEventDirector.this.juploadr.getUploadButton();
                button.setEnabled(true);
                button.setText(Messages.getString("juploadr.ui.button.upload.text.upload"));
                button.setSize(button.computeSize(-1, -1));
            }
        };
        this.reusableUIFactory.getDisplay().syncExec(r);
    }

    public void uploadCancelled() {
        this.resetUploadButton();
    }

    public void uploadFailed(final UploadEvent e) {
        this.failedUploads.add(e);
        final Map imageAttributes = this.juploadr.getImageAttributes();
        Runnable r = new Runnable(){

            public void run() {
                ImageAttributes att = (ImageAttributes)imageAttributes.get(e.getSource().getKey());
                att.setState(0);
                att.getButton().redraw();
            }
        };
        this.reusableUIFactory.getDisplay().syncExec(r);
    }

    private void handleSelectAll() {
        Iterator iter = this.juploadr.getImageAttributes().values().iterator();
        while (iter.hasNext()) {
            ((ImageAttributes)iter.next()).setSelected(true);
        }
        this.juploadr.refresh();
    }

    private void handleShiftClick() {
        ImageAttributes clicked = ((Thumbnail)this.clickedOrder.pop()).getImageAttributes();
        if (!this.clickedOrder.isEmpty()) {
            int myIndex;
            int direction;
            ImageAttributes startSelection = ((Thumbnail)this.clickedOrder.pop()).getImageAttributes();
            ArrayList photos = new ArrayList(this.juploadr.getImageAttributes().values());
            Collections.sort(photos, new ImageAttributesRankComparator());
            int n = direction = clicked.getRank() - startSelection.getRank() > 0 ? 1 : -1;
            if (direction < 0) {
                ImageAttributes tmp = startSelection;
                startSelection = clicked;
                clicked = tmp;
            }
            if ((myIndex = photos.indexOf(clicked)) > 0) {
                ImageAttributes photo;
                for (int i = myIndex - 1; i > 0 && (photo = (ImageAttributes)photos.get(i)).isSelected() != clicked.isSelected(); --i) {
                    photo.toggleSelected();
                }
                this.juploadr.refresh();
            }
        }
    }

    private void deselectAll() {
        Map photos = this.juploadr.getImageAttributes();
        if (photos != null) {
            Iterator iter = photos.values().iterator();
            while (iter.hasNext()) {
                ImageAttributes photo = (ImageAttributes)iter.next();
                photo.setSelected(false);
            }
            this.juploadr.refresh();
        }
    }

    private void handleFileDrop(DropTargetEvent event) {
        String[] files = (String[])event.data;
        for (int i = 0; i < files.length; ++i) {
            File f = new File(files[i]);
            if (f.isFile()) {
                this.juploadr.addButton(files[i]);
                continue;
            }
            if (!f.isDirectory()) continue;
            File[] dirFiles = f.listFiles();
            for (int j = 0; j < dirFiles.length; ++j) {
                this.juploadr.addButton(dirFiles[j].getAbsolutePath());
            }
        }
    }

    private void deleteSelected() {
        if (this.juploadr.getImageAttributes().size() > 0) {
            Iterator iter = this.juploadr.getImageAttributes().values().iterator();
            while (iter.hasNext()) {
                ImageAttributes value = (ImageAttributes)iter.next();
                if (!value.isSelected()) continue;
                iter.remove();
                value.removeFromWindow();
            }
            this.juploadr.refresh();
        }
    }

    public class DefaultKeyListener
    implements KeyListener {
        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 97 && (event.stateMask | 0x40000) != 0) {
                JUploadrEventDirector.this.handleSelectAll();
            } else if (event.keyCode == 127) {
                JUploadrEventDirector.this.deleteSelected();
            }
        }

        public void keyReleased(KeyEvent event) {
        }
    }

    public class GenericListener
    implements Listener {
        public void handleEvent(Event event) {
            Shell window = JUploadr.window;
            switch (event.type) {
                case 35: {
                    new TrayPopupHandler(window, JUploadrEventDirector.this.juploadr);
                    break;
                }
                case 14: {
                    window.setVisible(!window.getVisible());
                }
            }
        }
    }

    public class DropTargetListener
    extends DropTargetAdapter {
        public void drop(DropTargetEvent event) {
            if (JUploadrEventDirector.this.juploadr.getFileTransfer().isSupportedType(event.currentDataType)) {
                JUploadrEventDirector.this.handleFileDrop(event);
            }
        }
    }

    public class MouseListener
    extends MouseAdapter {
        public void mouseDown(MouseEvent event) {
            if (event.button == 1 && event.stateMask != 262144 && event.widget instanceof Thumbnail) {
                Thumbnail t = (Thumbnail)event.widget;
                JUploadrEventDirector.this.clickedOrder.push(t);
                if (event.stateMask == 131072) {
                    JUploadrEventDirector.this.handleShiftClick();
                }
                t.redraw();
            } else if (event.button == 3 || event.stateMask == 262144 && event.button == 1) {
                if (event.widget instanceof Thumbnail) {
                    Thumbnail thumb = (Thumbnail)event.widget;
                    ImageUploadApi.getInstance().thumbnailRightClicked((Decorations)JUploadr.window, JUploadrEventDirector.this.juploadr, thumb.getImageAttributes());
                } else if (JUploadrEventDirector.this.juploadr.getImageAttributes().size() > 0) {
                    ImageUploadApi.getInstance().windowRightClicked((Decorations)JUploadr.window, JUploadrEventDirector.this.juploadr);
                }
            }
        }

        public void mouseUp(MouseEvent event) {
            if (!(event.widget instanceof Thumbnail)) {
                JUploadrEventDirector.this.deselectAll();
            }
        }
    }
}

