/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.event;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.event.UploadEvent;
import org.scohen.juploadr.event.UploadStatusMonitor;

public class EventOutputStream
extends OutputStream {
    private OutputStream source;
    private List listeners;
    private int bytesWritten;
    private String fileName;
    private UploadImage image;

    public EventOutputStream(OutputStream src, UploadImage image, int delay) {
        this.source = src;
        this.image = image;
    }

    public void write(byte[] buffer, int offset, int rename) throws IOException {
        this.bytesWritten += rename;
        this.fireEvents();
        this.source.write(buffer, offset, rename);
    }

    public void write(byte[] arg0) throws IOException {
        if (arg0 != null) {
            this.bytesWritten += arg0.length;
        }
        this.fireEvents();
        this.source.write(arg0);
    }

    public void write(int arg0) throws IOException {
        ++this.bytesWritten;
        this.fireEvents();
        this.source.write(arg0);
    }

    public void addUploadStatusMonitor(UploadStatusMonitor toAdd) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(toAdd);
    }

    public void close() throws IOException {
        this.source.close();
    }

    public boolean equals(Object arg0) {
        return this.source.equals(arg0);
    }

    public void flush() throws IOException {
        this.source.flush();
        this.fireEvents();
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public String toString() {
        return this.source.toString();
    }

    private void fireEvents() {
        UploadEvent event = new UploadEvent();
        event.setSource(this.image);
        event.setBytesWritten(this.bytesWritten);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            UploadStatusMonitor element = (UploadStatusMonitor)iter.next();
            element.uploadStatusChanged(event);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

