/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.prefs;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.prefs.BaseConfigurationForm;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.prefs.Fault;

public class ConnectionForm
extends BaseConfigurationForm {
    private static final Configuration config = Configuration.getInstance();
    private Button useProxy;
    private Text host;
    private Text port;
    private Text username;
    private Text password;
    private Button throttleBandwidth;
    private Text throttleKPerSecond;
    private Label throttleKPerSecondLabel;
    private Label hostLabel;
    private Label portLabel;
    private Label usernameLabel;
    private Label passwordLabel;
    private Group proxyGroup;
    private Group throttleGroup;

    public ConnectionForm(Composite parent) {
        super(parent);
    }

    protected void initUI() {
        GridLayout layout = new GridLayout();
        GridData data = new GridData(768);
        this.initBandwidthThrottlingUI();
        this.useProxy = new Button((Composite)this, 32);
        this.useProxy.setText(Messages.getString("juploadr.ui.label.enable.proxy"));
        this.useProxy.setSelection(config.isProxyEnabled());
        this.useProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionForm.this.proxyButtonClicked();
            }
        });
        this.proxyGroup = new Group((Composite)this, 32);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        this.proxyGroup.setLayout((Layout)layout);
        this.proxyGroup.setLayoutData((Object)new GridData(768));
        this.proxyGroup.setText(Messages.getString("juploadr.ui.label.proxy.settings"));
        this.proxyGroup.setEnabled(this.useProxy.getSelection());
        this.hostLabel = new Label((Composite)this.proxyGroup, 0);
        this.hostLabel.setText(Messages.getString("juploadr.ui.label.proxy.host"));
        this.host = new Text((Composite)this.proxyGroup, 2048);
        this.host.setText(config.getProxyHost());
        this.host.setLayoutData((Object)data);
        this.portLabel = new Label((Composite)this.proxyGroup, 0);
        this.portLabel.setText(Messages.getString("juploadr.ui.label.proxy.port"));
        this.port = new Text((Composite)this.proxyGroup, 2048);
        this.port.setText(String.valueOf(config.getProxyPort()));
        GC gc = new GC((Drawable)this.proxyGroup);
        GridData portData = new GridData();
        portData.widthHint = gc.textExtent((String)"0000").x;
        this.port.setLayoutData((Object)portData);
        gc.dispose();
        this.port.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text.length() > 0) {
                    try {
                        Integer.parseInt(e.text);
                    }
                    catch (NumberFormatException nfe) {
                        e.doit = false;
                    }
                }
            }
        });
        this.usernameLabel = new Label((Composite)this.proxyGroup, 0);
        this.usernameLabel.setText(Messages.getString("juploadr.ui.label.proxy.username"));
        this.username = new Text((Composite)this.proxyGroup, 2048);
        this.username.setText(config.getProxyUsername());
        data = new GridData(768);
        this.username.setLayoutData((Object)data);
        this.passwordLabel = new Label((Composite)this.proxyGroup, 0);
        this.passwordLabel.setText(Messages.getString("juploadr.ui.label.proxy.password"));
        this.password = new Text((Composite)this.proxyGroup, 0x400800);
        this.password.setText(config.getProxyPassword());
        data = new GridData(768);
        this.password.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ConnectionForm.this.disposed(event);
            }
        });
        this.setFieldsEnabled(config.isProxyEnabled());
        this.setThrottlingFieldsEnabled(config.isThrottlingEnabled());
    }

    private void initBandwidthThrottlingUI() {
        this.throttleBandwidth = new Button((Composite)this, 32);
        this.throttleBandwidth.setText(Messages.getString("juploadr.ui.connection.label.throttle-upstream"));
        this.throttleBandwidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionForm.this.throttleButtonClicked();
            }
        });
        this.throttleGroup = new Group((Composite)this, 32);
        this.throttleGroup.setText(Messages.getString("juploadr.ui.connection.label.throttling.settings"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        this.throttleGroup.setLayout((Layout)layout);
        this.throttleGroup.setLayoutData((Object)new GridData(768));
        this.throttleKPerSecondLabel = new Label((Composite)this.throttleGroup, 0);
        this.throttleKPerSecondLabel.setText(Messages.getString("juploadr.ui.connection.label.maxupload"));
        this.throttleKPerSecond = new Text((Composite)this.throttleGroup, 2048);
        this.throttleKPerSecond.setLayoutData((Object)new GridData(768));
        if (config.isThrottlingEnabled()) {
            this.throttleKPerSecond.setText(Integer.toString(config.getMaxKPerSecond() / 1024, 10));
        }
        this.throttleKPerSecond.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.text.length() > 0) {
                    String input = ((Text)event.widget).getText() + event.text;
                    try {
                        int kbps = Integer.parseInt(input);
                        if (kbps <= 0) {
                            event.doit = false;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        event.doit = false;
                    }
                }
            }
        });
    }

    protected void throttleButtonClicked() {
        this.setThrottlingFieldsEnabled(this.throttleBandwidth.getSelection());
        this.redraw();
    }

    private void setThrottlingFieldsEnabled(boolean enabled) {
        this.throttleBandwidth.setSelection(enabled);
        this.throttleKPerSecond.setEnabled(enabled);
        this.throttleKPerSecondLabel.setEnabled(enabled);
        this.throttleGroup.setEnabled(enabled);
    }

    private void setFieldsEnabled(boolean enabled) {
        this.proxyGroup.setEnabled(enabled);
        this.host.setEnabled(enabled);
        this.hostLabel.setEnabled(enabled);
        this.port.setEnabled(enabled);
        this.portLabel.setEnabled(enabled);
        this.username.setEnabled(enabled);
        this.usernameLabel.setEnabled(enabled);
        this.password.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
        this.redraw();
    }

    private void proxyButtonClicked() {
        this.setFieldsEnabled(this.useProxy.getSelection());
    }

    public void saveChanges() {
        config.setThrottlingEnabled(this.throttleBandwidth.getSelection());
        if (this.throttleBandwidth.getSelection()) {
            config.setMaxKPerSecond(Integer.parseInt(this.throttleKPerSecond.getText()) * 1024);
        }
        if (this.useProxy.getSelection()) {
            config.setProxyEnabled(true);
            config.setProxyHost(this.host.getText());
            String portNum = this.port.getText();
            config.setProxyPort(portNum.length() > 0 ? Integer.parseInt(portNum) : 8080);
            config.setProxyUsername(this.username.getText());
            config.setProxyPassword(this.password.getText());
        } else {
            config.setProxyEnabled(false);
        }
    }

    public Fault validateChanges() {
        return null;
    }

    public String getFormName() {
        return Messages.getString("juploadr.ui.proxy.form.title");
    }

    public void disposed(DisposeEvent event) {
        this.useProxy.dispose();
        this.proxyGroup.dispose();
        this.host.dispose();
        this.port.dispose();
        this.username.dispose();
        this.password.dispose();
        this.hostLabel.dispose();
        this.portLabel.dispose();
        this.usernameLabel.dispose();
        this.passwordLabel.dispose();
        this.throttleBandwidth.dispose();
        this.throttleKPerSecond.dispose();
        this.throttleKPerSecondLabel.dispose();
        this.throttleGroup.dispose();
    }
}

