/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.prefs;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.prefs.ConfigurationDialog;
import org.scohen.juploadr.prefs.ConfigurationForm;
import org.scohen.juploadr.prefs.Fault;
import org.scohen.juploadr.prefs.Problem;
import org.scohen.juploadr.ui.MessageUtils;

public class UploadActionForm
extends Composite
implements ConfigurationForm {
    private static final String OPTION_CUSTOM = "";
    private Button sortByExif;
    private Button removeUploaded;
    private Button enableAutoResize;
    private Button enableImageIOScaler;
    private Composite autoResizeGroup;
    private Configuration config = Configuration.getInstance();
    private Button option1280;
    private Button option1024;
    private Button option800;
    private Button optionCustom;
    private Text txtCustom;
    private Group radioGroup;
    private Label customLabel;

    public UploadActionForm(Composite parent) {
        super(parent, 0);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                UploadActionForm.this.disposed();
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.sortByExif = new Button((Composite)this, 32);
        this.sortByExif.setText(Messages.getString("juploadr.ui.uploadactionform.label.sort.by.date"));
        this.sortByExif.setSelection(this.config.getUploadByExifDate());
        this.removeUploaded = new Button((Composite)this, 32);
        this.removeUploaded.setText(Messages.getString("juploadr.ui.label.remove.uploaded"));
        this.removeUploaded.setSelection(this.config.getAutoRemoveUploadedPhotos());
        layout = new GridLayout();
        layout.numColumns = 1;
        this.autoResizeGroup = new Composite((Composite)this, 0);
        this.autoResizeGroup.setLayout((Layout)layout);
        this.autoResizeGroup.setLayoutData((Object)new GridData(1808));
        this.enableAutoResize = new Button(this.autoResizeGroup, 32);
        this.enableAutoResize.setText(Messages.getString("juploadr.ui.label.resize"));
        this.enableAutoResize.setSelection(this.config.getAutoResizePhotos());
        this.enableAutoResize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UploadActionForm.this.toggleResizeControls();
            }
        });
        this.enableImageIOScaler = new Button(this.autoResizeGroup, 32);
        this.enableImageIOScaler.setText(Messages.getString("juploadr.ui.enable.high.quality.resizing"));
        this.enableImageIOScaler.setSelection(this.config.isScalingQualityFavored());
        this.enableImageIOScaler.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UploadActionForm.this.toggleImageIo(UploadActionForm.this.enableImageIOScaler.getSelection());
            }
        });
        this.radioGroup = new Group(this.autoResizeGroup, 32);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.radioGroup.setText(Messages.getString("juploadr.ui.label.limit.maxsize"));
        this.radioGroup.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        this.radioGroup.setLayoutData((Object)gridData);
        this.radioGroup.setEnabled(this.config.getAutoResizePhotos());
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.option1280 = this.getRadio(this.radioGroup, "1280");
        this.option1280.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.option1024 = this.getRadio(this.radioGroup, "1024");
        this.option1024.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.option800 = this.getRadio(this.radioGroup, "800");
        this.option800.setLayoutData((Object)gridData);
        this.optionCustom = this.getRadio(this.radioGroup, OPTION_CUSTOM);
        this.optionCustom.setText(OPTION_CUSTOM);
        this.optionCustom.setSelection(!this.option1024.getSelection() && !this.option800.getSelection() && !this.option1280.getSelection());
        this.txtCustom = new Text((Composite)this.radioGroup, 2052);
        this.txtCustom.setEnabled(this.config.getAutoResizePhotos());
        if (this.optionCustom.getSelection()) {
            this.txtCustom.setText(String.valueOf(this.config.getMaxPhotoSize()));
        }
        GC gc = new GC((Drawable)this.txtCustom);
        gridData = new GridData();
        gridData.widthHint = gc.textExtent((String)"0000").x;
        this.txtCustom.setLayoutData((Object)gridData);
        this.txtCustom.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text.length() > 0) {
                    try {
                        Integer.parseInt(e.text);
                    }
                    catch (NumberFormatException e1) {
                        e.doit = false;
                    }
                }
            }
        });
        this.customLabel = new Label((Composite)this.radioGroup, 0);
        this.customLabel.setText(Messages.getString("juploadr.ui.label.pixels.largest.side"));
        this.customLabel.setEnabled(this.config.getAutoResizePhotos());
        gc.dispose();
    }

    protected void toggleImageIo(boolean enabled) {
        this.config.setImageIORescalerEnabled(enabled);
        if (enabled) {
            MessageUtils.showMessage(Messages.getString("juploadr.ui.enable.high.quality.resizing.warning.message"), Messages.getString("juploadr.ui.enable.high.quality.resizing.title"), 8);
        }
    }

    private Button getRadio(Group parent, String text) {
        int size = 0;
        Button b = new Button((Composite)parent, 16);
        try {
            size = Integer.parseInt(text);
            if (size == this.config.getMaxPhotoSize()) {
                b.setSelection(true);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        b.setText(text + Messages.getString("juploadr.ui.label.pixels.largest.side"));
        b.setEnabled(this.config.getAutoResizePhotos());
        return b;
    }

    public void saveChanges() {
        this.config.setAutoRemoveUploadedPhotos(this.removeUploaded.getSelection());
        this.config.setAutoResizePhotos(this.enableAutoResize.getSelection());
        this.config.setUploadByExifDate(this.sortByExif.getSelection());
        if (this.config.getAutoResizePhotos()) {
            Control[] children = this.radioGroup.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Button button;
                if (!(children[i] instanceof Button) || !(button = (Button)children[i]).getSelection()) continue;
                if (OPTION_CUSTOM.equals(button.getText())) {
                    this.config.setMaxPhotoSize(Integer.parseInt(this.txtCustom.getText()));
                    continue;
                }
                String size = button.getText().substring(0, button.getText().indexOf(" "));
                this.config.setMaxPhotoSize(Integer.parseInt(size));
            }
        }
    }

    public Fault validateChanges() {
        Problem fault = null;
        if (this.optionCustom.getSelection() && this.txtCustom.getText().length() == 0) {
            fault = new Problem(Messages.getString("juploadr.ui.error.size.required"));
        }
        return fault;
    }

    public String getFormName() {
        return Messages.getString("juploadr.ui.uploadactionform.title");
    }

    public void toggleResizeControls() {
        boolean enabled = !this.radioGroup.isEnabled();
        this.radioGroup.setEnabled(enabled);
        Control[] radioButtions = this.radioGroup.getChildren();
        for (int i = 0; i < radioButtions.length; ++i) {
            Control radio = radioButtions[i];
            radio.setEnabled(enabled);
        }
        this.redraw();
    }

    private void disposed() {
        this.removeUploaded.dispose();
        this.enableAutoResize.dispose();
        this.autoResizeGroup.dispose();
        this.option1024.dispose();
        this.option1280.dispose();
        this.option800.dispose();
        this.optionCustom.dispose();
        this.radioGroup.dispose();
    }

    public void setConfigurationDialog(ConfigurationDialog dialog) {
    }

    public void accountChanged() {
    }
}

