/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui;

import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.scohen.juploadr.ui.PopupData;

public abstract class PopupHandler {
    protected static final String SEPARATOR = "---";
    protected static final int MAX_SUBMENU_SIZE = 15;
    protected List options;
    protected Menu popupMenu;
    protected Decorations parent;
    protected Object target;
    protected SelectionListener listener;

    protected PopupHandler(Decorations parent) {
        this.parent = parent;
        DisposeListener dl = new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (PopupHandler.this.popupMenu != null) {
                    PopupHandler.this.popupMenu.dispose();
                }
            }
        };
        parent.addDisposeListener(dl);
    }

    protected abstract void regenerateOptions();

    protected abstract void widgetSelected(SelectionEvent var1);

    protected void widgetDefaultSelected(SelectionEvent event) {
    }

    protected void initUI() {
        this.popupMenu = new Menu(this.parent, 8);
        this.listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                PopupHandler.this.widgetSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                PopupHandler.this.widgetDefaultSelected(event);
            }
        };
        for (int i = 0; i < this.options.size(); ++i) {
            MenuItem next;
            PopupData nvp = (PopupData)this.options.get(i);
            if (nvp.hasChildren()) {
                next = new MenuItem(this.popupMenu, 64);
                Menu parent = new Menu(next);
                next.setMenu(parent);
                this.newItem(nvp, next);
                this.addChildren(parent, nvp);
                continue;
            }
            if (nvp.equals(PopupData.SEPARATOR)) {
                next = new MenuItem(this.popupMenu, 2);
                continue;
            }
            next = new MenuItem(this.popupMenu, nvp.getType());
            this.newItem(nvp, next);
        }
    }

    private void addChildren(Menu parent, PopupData popup) {
        if (popup.hasChildren()) {
            List children = popup.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                MenuItem item;
                PopupData child = (PopupData)children.get(i);
                if (child.hasChildren()) {
                    item = new MenuItem(parent, 64);
                    this.newItem(child, item);
                    Menu subMenu = new Menu(item);
                    item.setMenu(subMenu);
                    this.addChildren(subMenu, child);
                    continue;
                }
                item = child.equals(PopupData.SEPARATOR) ? new MenuItem(parent, 2) : new MenuItem(parent, child.getType());
                this.newItem(child, item);
            }
        }
    }

    private void newItem(PopupData data, MenuItem item) {
        item.setData(data.getValue());
        item.setText(data.getText());
        item.setEnabled(data.isEnabled());
        item.setSelection(data.isChecked());
        item.addSelectionListener(this.listener);
    }

    protected void show() {
        this.regenerateOptions();
        this.initUI();
        this.popupMenu.setVisible(true);
    }
}

