/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.Task;

public class ProgressDialog
extends Dialog {
    private static final int HORIZONTAL_INDENT = 5;
    private String message;
    private int min;
    private int max;
    public ProgressBar bar;
    Shell shell;
    private Shell parent;
    Label msgLabel;
    private Display display;
    private Task task;
    private Canvas icon;

    protected ProgressDialog(Shell parent, int style) {
        super(parent, style);
    }

    public ProgressDialog(Shell parent, Task t) {
        this(parent, 0);
        this.display = parent.getDisplay();
        this.parent = parent;
        this.task = t;
        this.task.setParent(this);
    }

    public void open() {
        this.shell = new Shell(this.parent, 67680);
        this.shell.setText(this.task.getTitle());
        if (!Configuration.isMac()) {
            this.shell.setImage(ReusableUIFactory.getInstance().getTinyLogoImage());
        }
        GridLayout layout = new GridLayout();
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        this.getIcon();
        this.getMessageLabel();
        this.getProgressBar();
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void close() {
        this.shell.setVisible(false);
        this.shell.close();
        this.disposed();
    }

    public void execute() {
        this.task.setParent(this);
        if (this.max > this.min) {
            this.task.start();
            this.open();
        }
    }

    private void getProgressBar() {
        this.bar = new ProgressBar((Composite)this.shell, 256);
        GridData data = new GridData(4, 0x1000008, true, false);
        data.horizontalIndent = 5;
        this.bar.setLayoutData((Object)data);
        this.bar.setMaximum(this.max);
        this.bar.setMinimum(this.min);
    }

    private void getMessageLabel() {
        this.msgLabel = new Label((Composite)this.shell, 256);
        GridData data = new GridData(4, 4, true, false);
        GC gc = new GC((Drawable)this.msgLabel);
        data.widthHint = gc.textExtent((String)"MMMMMMMMMMMMMMMMMMMMMMMMMM").x;
        data.heightHint = gc.textExtent((String)"0\n0\n0\n0\n0").y;
        gc.dispose();
        data.horizontalIndent = 5;
        this.msgLabel.setLayoutData((Object)data);
        this.msgLabel.setText(this.message);
    }

    private void getIcon() {
        this.icon = new Canvas((Composite)this.shell, 0);
        final Task t = this.task;
        this.icon.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc = event.gc;
                Image icon = t.getIcon();
                ImageData iconData = icon.getImageData();
                gc.drawImage(icon, 0, 0, iconData.width, iconData.height, 0, 0, 64, 64);
            }
        });
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.verticalSpan = 2;
        this.icon.setLayoutData((Object)data);
    }

    private void disposed() {
        if (!this.shell.isDisposed()) {
            this.bar.dispose();
            this.shell.dispose();
            this.msgLabel.dispose();
            this.icon.dispose();
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }
}

