/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui.thumbnail;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Composite;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.tags.TagParser;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.thumbnail.AbstractThumbnailDecorator;
import org.scohen.juploadr.ui.thumbnail.Thumbnail;

public class TagsThumbnailDecorator
extends AbstractThumbnailDecorator {
    private static final int BORDER_TOP = 1;
    private static final int BORDER_LEFT = 2;
    private static final int BORDER_BOTTOM = 4;
    private static int TAB_WIDTH = 85;
    private static int TAB_HEIGHT = 15;
    private boolean displayText = false;
    public Color friends;
    private Color privateColor;
    private Color family;
    private Color publicColor;
    private Color description;
    private Color titleColor;
    private Color tags;
    private ReusableUIFactory uiFactory = ReusableUIFactory.getInstance();

    public TagsThumbnailDecorator(Composite parent, ImageAttributes atts, Thumbnail t) {
        super(parent, atts, t);
        this.friends = this.uiFactory.getFriendsColor();
        this.family = this.uiFactory.getFamilyColor();
        this.privateColor = this.uiFactory.getPrivateColor();
        this.publicColor = this.uiFactory.getPublicColor();
        this.tags = this.uiFactory.getTagColor();
        this.description = this.uiFactory.getDescriptionColor();
        this.titleColor = this.uiFactory.getTitleColor();
        t.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent event) {
                TagsThumbnailDecorator.this.displayText = true;
                TagsThumbnailDecorator.this.redraw();
            }

            public void mouseExit(MouseEvent event) {
                TagsThumbnailDecorator.this.displayText = false;
                TagsThumbnailDecorator.this.redraw();
            }
        });
    }

    void widgetDisposed(DisposeEvent e) {
    }

    void paintControl(PaintEvent event) {
        GC gc = event.gc;
        if (Configuration.getInstance().getUseImageLayovers()) {
            if (this.attrs.isPubliclyVisible()) {
                this.addPublicTab(gc);
            } else {
                this.addPrivateTab(gc);
                if (this.attrs.isFamilyViewable()) {
                    this.addFamilyTab(gc);
                }
                if (this.attrs.isFriendViewable()) {
                    this.addFriendsTab(gc);
                }
            }
            if (this.attrs.hasTags()) {
                this.addTagsTab(gc);
            }
            if (this.attrs.hasTitle()) {
                this.addTitleTag(gc);
            }
            if (this.attrs.hasDescription()) {
                this.addDescriptionTab(gc);
            }
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        ImageData data = image.getImageData();
        TAB_WIDTH = data.width;
        TAB_HEIGHT = data.height / 6;
    }

    private void addFamilyTab(GC gc) {
        int border = 2;
        if (!this.attrs.isFriendViewable() && this.displayText) {
            this.addTab("", gc, this.family, 1, 2);
        }
        this.addTab("   " + Messages.getString("juploadr.ui.label.family"), gc, this.family, 2, border |= 4);
    }

    private void addFriendsTab(GC gc) {
        int border = 2;
        if (!this.attrs.isFamilyViewable()) {
            border |= 4;
        }
        this.addTab("   " + Messages.getString("juploadr.ui.label.friends"), gc, this.friends, 1, border);
    }

    private void addPublicTab(GC gc) {
        this.addTab(Messages.getString("juploadr.ui.label.public"), gc, this.publicColor, 0, 6);
    }

    private void addPrivateTab(GC gc) {
        int border = 6;
        this.addTab(Messages.getString("juploadr.ui.label.private"), gc, this.privateColor, 0, border);
    }

    private void addTagsTab(GC gc) {
        int border = 2;
        if (!this.attrs.hasTitle()) {
            border |= 4;
        }
        if (this.attrs.isPubliclyVisible() || !this.attrs.isFamilyViewable()) {
            border |= 1;
        }
        this.addTab(TagParser.toInputString(this.attrs.getTags()), gc, this.description, 3, border);
    }

    private void addTitleTag(GC gc) {
        int border = 2;
        if (!this.attrs.hasTags()) {
            border |= 1;
        }
        if (!this.attrs.hasDescription()) {
            border |= 4;
        }
        this.addTab(this.attrs.getTitle(), gc, this.titleColor, 4, border);
    }

    private void addDescriptionTab(GC gc) {
        int border = 6;
        if (!this.attrs.hasTitle()) {
            border |= 1;
        }
        this.addTab(this.attrs.getDescription(), gc, this.tags, 5, border);
    }

    private void addTab(String message, GC gc, Color bgColor, int offset, int borders) {
        if (this.attrs.getState() != 1 && this.attrs.getState() != 8) {
            ImageData data = new ImageData(TAB_WIDTH, TAB_HEIGHT, 24, new PaletteData(0, 0, 0));
            data.alpha = this.displayText ? 180 : 64;
            Image tab = new Image((Device)this.uiFactory.getDisplay(), data);
            Color borderColor = this.uiFactory.getTagBorderColor();
            Color white = this.uiFactory.getWhiteColor();
            GC tabGC = new GC((Drawable)tab);
            tabGC.setFont(this.uiFactory.getThumbnailDecorationFont());
            tabGC.setBackground(bgColor);
            tabGC.fillRectangle(0, 0, TAB_WIDTH, TAB_HEIGHT);
            tabGC.setForeground(white);
            if (this.displayText) {
                tabGC.drawString(this.truncateText(message, tabGC), 2, 1);
                tabGC.setForeground(borderColor);
                if ((borders & 2) != 0) {
                    tabGC.drawLine(0, 0, 0, TAB_HEIGHT);
                }
                if ((borders & 1) != 0) {
                    tabGC.drawLine(0, 0, TAB_WIDTH, 0);
                }
                if ((borders & 4) != 0) {
                    tabGC.drawLine(0, TAB_HEIGHT - 1, TAB_WIDTH, TAB_HEIGHT - 1);
                }
            }
            gc.drawImage(tab, this.THUMBNAIL_WIDTH - (5 + TAB_WIDTH + 1), 5 + offset * TAB_HEIGHT);
            tabGC.dispose();
            tab.dispose();
        }
    }

    private String truncateText(String orig, GC gc) {
        FontMetrics metrics = gc.getFontMetrics();
        int stringWidth = gc.textExtent((String)orig).x;
        int imageWidth = this.thumb.getImage().getImageData().width;
        if (stringWidth > imageWidth) {
            StringBuffer sb = new StringBuffer();
            stringWidth = 0;
            int charPos = 0;
            sb.append("...");
            while (stringWidth < imageWidth - metrics.getAverageCharWidth()) {
                sb.insert(sb.length() - 3, orig.charAt(charPos));
                stringWidth = gc.textExtent((String)sb.toString()).x;
                ++charPos;
            }
            return sb.toString();
        }
        return orig;
    }
}

