/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui.thumbnail;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Composite;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.ui.thumbnail.AbstractThumbnailDecorator;
import org.scohen.juploadr.ui.thumbnail.Thumbnail;

public class UploadStateThumbnailDecorator
extends AbstractThumbnailDecorator {
    private static final int PHOTO_COLOR_DEPTH = 32;
    private Image uploading;
    private Image uploaded;
    private ReusableUIFactory uiFactory = ReusableUIFactory.getInstance();

    public UploadStateThumbnailDecorator(Composite parent, ImageAttributes atts, Thumbnail t) {
        super(parent, atts, t);
        this.uploading = this.uiFactory.getUploadingImage();
        this.uploaded = this.uiFactory.getUploadedImage();
    }

    void paintControl(PaintEvent event) {
        ImageData imageData = this.getImage().getImageData();
        GC gc = event.gc;
        if (this.attrs.getState() == 1) {
            ImageData copyData = new ImageData(imageData.width, imageData.height, 32, new PaletteData(255, 65280, 0xFF0000));
            copyData.alpha = 64;
            Color white = new Color((Device)event.widget.getDisplay(), 255, 255, 255);
            Image copy = new Image((Device)event.widget.getDisplay(), copyData);
            GC cGC = new GC((Drawable)copy);
            cGC.setBackground(white);
            cGC.fillRectangle(0, 0, copyData.width, copyData.height);
            gc.drawImage(copy, 5, 5);
            copy.dispose();
            cGC.dispose();
            white.dispose();
            int center = this.THUMBNAIL_WIDTH / 2;
            int myWidth = this.uploading.getImageData().width;
            gc.drawImage(this.uploaded, center - myWidth / 2, 5);
        } else if (this.attrs.getState() == 8) {
            int center = this.THUMBNAIL_WIDTH / 2;
            int myWidth = this.uploading.getImageData().width;
            gc.drawImage(this.uploading, center - myWidth / 2, 5);
        }
    }

    void widgetDisposed(DisposeEvent e) {
    }
}

