/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.upload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BandwidthThrottlingOutputStream
extends OutputStream {
    private static final int FREQUENCY = 8;
    private static final int WINDOW_LENGTH = 125;
    private int bytesPerWindow;
    private int bytesWrittenThisWindow = 0;
    private long windowEnd;
    private OutputStream out;
    long writeStartedAt = -1L;

    public BandwidthThrottlingOutputStream(OutputStream out, int maxBytesPerSecond) {
        this.bytesPerWindow = maxBytesPerSecond / 8;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        this.checkTime();
        if (this.bytesWrittenThisWindow > this.bytesPerWindow) {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                try {
                    this.out.wait(this.windowEnd - System.currentTimeMillis());
                }
                catch (InterruptedException e) {
                    throw new IOException("Write interrupted");
                }
            }
        }
        this.out.write(b);
        ++this.bytesWrittenThisWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= this.bytesPerWindow) {
            this.out.write(b, off, len);
        } else {
            byte[] buffer = new byte[this.bytesPerWindow];
            ByteArrayInputStream in = new ByteArrayInputStream(b, off, len);
            while (in.available() > 0) {
                this.checkTime();
                int numread = in.read(buffer);
                this.out.write(buffer, 0, numread);
                this.bytesWrittenThisWindow += numread;
                if (this.bytesWrittenThisWindow <= this.bytesPerWindow) continue;
                OutputStream outputStream = this.out;
                synchronized (outputStream) {
                    try {
                        this.out.wait(this.windowEnd - System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Write interrupted");
                    }
                }
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void setMaxBytesPerSecond(int bytesPerSecond) {
        this.bytesPerWindow = bytesPerSecond;
    }

    private void checkTime() {
        if (System.currentTimeMillis() - this.writeStartedAt >= 125L) {
            this.writeStartedAt = System.currentTimeMillis();
            this.windowEnd = this.writeStartedAt + 125L;
            this.bytesWrittenThisWindow = 0;
        }
    }
}

