/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.scohen.juploadr.upload.BandwidthThrottlingOutputStream;

public class BandwidthThrottlingSocket
extends Socket {
    private Socket wrapped;
    private int maxBytesPerSecond;

    public BandwidthThrottlingSocket(Socket wrapped, int maxBytesPerSecond) {
        this.wrapped = wrapped;
        this.maxBytesPerSecond = maxBytesPerSecond;
    }

    public OutputStream getOutputStream() throws IOException {
        return new BandwidthThrottlingOutputStream(this.wrapped.getOutputStream(), this.maxBytesPerSecond);
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.wrapped.bind(bindpoint);
    }

    public void close() throws IOException {
        this.wrapped.close();
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.wrapped.connect(endpoint, timeout);
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.wrapped.connect(endpoint);
    }

    public boolean equals(Object obj) {
        return this.wrapped.equals(obj);
    }

    public SocketChannel getChannel() {
        return this.wrapped.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.wrapped.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.wrapped.getInputStream();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.wrapped.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.wrapped.getLocalAddress();
    }

    public int getLocalPort() {
        return this.wrapped.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.wrapped.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.wrapped.getOOBInline();
    }

    public int getPort() {
        return this.wrapped.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.wrapped.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.wrapped.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.wrapped.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.wrapped.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.wrapped.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.wrapped.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.wrapped.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.wrapped.getTrafficClass();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean isBound() {
        return this.wrapped.isBound();
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    public boolean isConnected() {
        return this.wrapped.isConnected();
    }

    public boolean isInputShutdown() {
        return this.wrapped.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.wrapped.isOutputShutdown();
    }

    public void sendUrgentData(int data) throws IOException {
        this.wrapped.sendUrgentData(data);
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.wrapped.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.wrapped.setOOBInline(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.wrapped.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.wrapped.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.wrapped.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.wrapped.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.wrapped.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.wrapped.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.wrapped.setTrafficClass(tc);
    }

    public void shutdownInput() throws IOException {
        this.wrapped.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.wrapped.shutdownOutput();
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

