/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.upload;

import java.util.LinkedList;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.event.UploadCompleteEvent;
import org.scohen.juploadr.event.UploadEvent;
import org.scohen.juploadr.event.UploadStatusMonitor;
import org.scohen.juploadr.upload.MultiMonitorFacade;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.ImageUploadApi;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.UploadFailedException;

public class UploaderThread
extends Thread {
    private LinkedList uploadQueue;
    private UploadStatusMonitor monitor;
    private boolean uploadComplete = false;
    private boolean cancelled = false;

    public UploaderThread(LinkedList uploadQueue, UploadStatusMonitor monitor) {
        this.uploadQueue = uploadQueue;
        this.setMonitor(monitor);
    }

    private void verifyMonitor(UploadStatusMonitor monitor) {
        if (monitor == null) {
            monitor = new UploadStatusMonitor(){

                public void uploadStarted(UploadEvent e) {
                    System.out.println("UploadStarted " + e);
                }

                public void uploadStatusChanged(UploadEvent e) {
                    System.out.println("UploadStatusChanged " + e);
                }

                public void uploadFinished(UploadCompleteEvent e) {
                    System.out.println("UploadFinished " + e);
                }

                public void allUploadsComplete() {
                    System.out.println("AllUploadsComplete");
                }

                public void uploadCancelled() {
                    System.out.println("Upload cancelled");
                }

                public void uploadFailed(UploadEvent e) {
                    System.out.println("UploadFailed " + e);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            this.uploadComplete = false;
            UploadImage imageAttributes = null;
            LinkedList linkedList = this.uploadQueue;
            synchronized (linkedList) {
                if (this.uploadQueue.size() > 0 && !this.cancelled) {
                    imageAttributes = (UploadImage)this.uploadQueue.removeFirst();
                    if (this.uploadQueue.size() == 0) {
                        this.uploadComplete = true;
                    }
                } else {
                    if (this.cancelled) {
                        this.uploadQueue.clear();
                        this.monitor.uploadCancelled();
                    }
                    imageAttributes = null;
                    try {
                        this.uploadQueue.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (imageAttributes != null) {
                ImageUploadApi api = ImageUploadApi.getInstance();
                try {
                    if (!api.isCurrentAccountAuthenticated()) {
                        api.authenticateCurrentAccount();
                    }
                    api.upload(imageAttributes, this.monitor);
                }
                catch (UploadFailedException e) {
                    e.printStackTrace();
                    this.monitor.uploadFailed(new UploadEvent(imageAttributes, 0.0, true, false, e.getMessage()));
                }
                catch (CommunicationException e) {
                    this.monitor.uploadFailed(new UploadEvent(imageAttributes, 0.0, true, false, e.getMessage()));
                    e.printStackTrace();
                }
                catch (ProtocolException e) {
                    this.monitor.uploadFailed(new UploadEvent(imageAttributes, 0.0, false, false, e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (!this.uploadComplete) continue;
            this.monitor.allUploadsComplete();
        }
    }

    public UploadStatusMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(UploadStatusMonitor monitor) {
        MultiMonitorFacade multiMonitor = new MultiMonitorFacade();
        multiMonitor.addMonitor(monitor);
        this.verifyMonitor(monitor);
        this.monitor = multiMonitor;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

