/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.uploadapi;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.event.UploadCompleteEvent;
import org.scohen.juploadr.event.UploadStatusMonitor;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.PopupHandler;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.upload.HttpClientFactory;
import org.scohen.juploadr.uploadapi.Account;
import org.scohen.juploadr.uploadapi.CommunicationException;
import org.scohen.juploadr.uploadapi.NoPluginsFoundException;
import org.scohen.juploadr.uploadapi.PluginLocator;
import org.scohen.juploadr.uploadapi.ProtocolException;
import org.scohen.juploadr.uploadapi.UploadFailedException;
import org.scohen.juploadr.util.JUploadrBrowserLauncher;

public abstract class ImageUploadApi {
    private static ImageUploadApi[] implementations = null;
    private static ImageUploadApi instance = null;
    protected Image icon;

    public static synchronized ImageUploadApi getInstance() {
        if (instance == null) {
            try {
                for (int i = 0; i < implementations.length; ++i) {
                    if (!Configuration.getInstance().getUploadApiClassName().equalsIgnoreCase(implementations[i].getClass().getName())) continue;
                    instance = implementations[i];
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (!instance.isCurrentAccountNullAccount()) {
                    instance.authenticate(instance.getCurrentAccount());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ImageUploadApi.versionCheck();
            instance.initialize();
        }
        return instance;
    }

    public static final synchronized void changeImplementation(String newImplementation, JUploadr parent) {
        Configuration.getInstance().setUploadApiClassName(newImplementation);
        instance = null;
        ImageUploadApi.getInstance().initialize();
        Iterator photos = parent.getImageAttributes().values().iterator();
        while (photos.hasNext()) {
            ImageAttributes attr = (ImageAttributes)photos.next();
            attr.setState(0);
        }
        parent.refresh();
    }

    public synchronized Image getIcon() {
        if (this.icon == null) {
            String res = this.getClass().getPackage().getName() + ".resources.";
            res = res.replace('.', '/');
            this.icon = new Image((Device)ReusableUIFactory.getInstance().getDisplay(), this.getClass().getClassLoader().getResourceAsStream(res + "icon.png"));
        }
        return this.icon;
    }

    public abstract String getSiteName();

    public abstract Account getCurrentAccount();

    public abstract Account newAccount(String var1);

    public abstract void setCurrentAccount(Account var1);

    public abstract void initialize();

    public abstract boolean authenticate(Account var1) throws ProtocolException, CommunicationException;

    public abstract void upload(UploadImage var1, UploadStatusMonitor var2) throws UploadFailedException, CommunicationException;

    public abstract Class[] getConfiurationDialogs();

    public abstract PopupHandler windowRightClicked(Decorations var1, JUploadr var2);

    public abstract PopupHandler thumbnailRightClicked(Decorations var1, JUploadr var2, ImageAttributes var3);

    public abstract void postProcessUpload(UploadCompleteEvent var1, ImageAttributes var2);

    public abstract void postProcessAllUploads(Collection var1);

    public boolean isCurrentAccountAuthenticated() {
        return this.getCurrentAccount().isAuthenticated();
    }

    public abstract boolean isCurrentAccountNullAccount();

    public void authenticateCurrentAccount() throws ProtocolException, CommunicationException {
        this.authenticate(this.getCurrentAccount());
    }

    public static ImageUploadApi[] getRegisteredImplemtations() {
        return implementations;
    }

    public abstract List allAccounts();

    protected static void versionCheck() {
        Configuration config = Configuration.getInstance();
        HttpClient client = HttpClientFactory.getHttpClient();
        GetMethod get = new GetMethod("http://juploadr.sourceforge.net/version.txt");
        try {
            String version;
            int code = client.executeMethod((HttpMethod)get);
            if (code == 200 && (version = get.getResponseBodyAsString()) != null && config.shouldUpgradeTo(version = version.trim())) {
                if (MessageUtils.showMessage(Messages.getString("juploadr.ui.message.new.version.available") + Messages.getString("juploadr.ui.message.open.home.page"), Messages.getString("juploadr.ui.message.new.version"), 196)) {
                    JUploadrBrowserLauncher.openURL("http://juploadr.sourceforge.net");
                }
                config.setLastVersionAcked(version);
            }
        }
        catch (HttpException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static List allAccountsForAllApis() {
        LinkedList accounts = new LinkedList();
        for (int i = 0; i < implementations.length; ++i) {
            accounts.addAll(implementations[i].allAccounts());
        }
        Collections.sort(accounts, new Comparator(){

            public int compare(Object o1, Object o2) {
                Account a1 = (Account)o1;
                Account a2 = (Account)o2;
                if (a1.getClass().getName().equals(a2.getClass().getName())) {
                    return a1.getName().compareToIgnoreCase(a2.getName());
                }
                return a1.getClass().getName().compareToIgnoreCase(a2.getClass().getName());
            }
        });
        return accounts;
    }

    static {
        if (implementations == null) {
            try {
                implementations = new PluginLocator().getApis();
            }
            catch (NoPluginsFoundException e) {
                MessageUtils.showErrorMessage("Could not load any photo upload plugins");
            }
        }
    }
}

