/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.app;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.ui.ReusableUIFactory;

public class AboutDialog {
    private static final int BORDER_WIDTH = 5;
    private static final int BORDER_WIDTH_X2 = 10;
    private static final int MAX_OPACITY = 256;
    private static final int WIDTH = 280;
    private static final int INTERVAL = 10;
    private int opacity = 256;
    private Shell window;
    private ReusableUIFactory uiFactory = ReusableUIFactory.getInstance();
    private Runnable runnable;
    private Image image;
    private ImageData imageData;

    public AboutDialog() {
        this.init();
    }

    private void init() {
        this.image = this.uiFactory.getLogoImage();
        this.imageData = this.image.getImageData();
        this.window = new Shell(this.uiFactory.getDisplay(), 0x150000);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                AboutDialog.this.mouseDown(event);
            }
        };
        this.window.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                AboutDialog.this.handlePaint(e);
            }
        });
        this.window.addMouseListener((MouseListener)disposeOnClick);
        Rectangle clientArea = this.uiFactory.getDisplay().getClientArea();
        this.window.setBounds(clientArea.width / 2 - 140, clientArea.height / 2 - 140, 280, 280);
        this.window.setVisible(true);
        this.animate();
    }

    private void animate() {
        this.runnable = new Runnable(){

            public void run() {
                AboutDialog.this.opacity = AboutDialog.this.opacity - 4;
                if (AboutDialog.this.opacity <= 0 || AboutDialog.this.window.isDisposed()) {
                    return;
                }
                AboutDialog.this.window.redraw();
                AboutDialog.this.uiFactory.getDisplay().timerExec(10, AboutDialog.this.runnable);
            }
        };
        this.uiFactory.getDisplay().timerExec(10, this.runnable);
    }

    protected void handlePaint(PaintEvent e) {
        this.paintControl(e);
    }

    protected void mouseDown(MouseEvent event) {
        this.window.dispose();
    }

    protected void paintControl(PaintEvent event) {
        Image buffer = new Image((Device)event.display, 280, 280);
        GC gc = new GC((Drawable)buffer);
        if (this.opacity < 255) {
            gc.setBackground(this.uiFactory.getWhiteColor());
            gc.fillRectangle(5, 5, 270, this.imageData.height + 10);
            gc.drawImage(this.uiFactory.getLogoImage(), 140 - this.imageData.width / 2, 10);
        } else {
            gc.setBackground(this.uiFactory.getBlackColor());
            gc.fillRectangle(5, 5, 270, this.imageData.height + 10);
        }
        gc.setForeground(this.uiFactory.getThumbnailBorderColor());
        gc.drawRectangle(5, 5, 270, this.imageData.height + 10);
        ImageData alphaData = new ImageData(270, this.imageData.height + 10, this.imageData.depth, new PaletteData(255, 65280, 0xFF0000));
        alphaData.alpha = this.opacity;
        Image alphaImage = new Image((Device)this.uiFactory.getDisplay(), alphaData);
        GC imageGC = new GC((Drawable)alphaImage);
        imageGC.setBackground(this.uiFactory.getBlackColor());
        imageGC.fillRectangle(0, 0, 270, this.imageData.height + 10);
        gc.drawImage(alphaImage, 5, 5);
        imageGC.dispose();
        alphaImage.dispose();
        this.drawText(gc);
        event.gc.drawImage(buffer, 0, 0);
        buffer.dispose();
    }

    private void drawText(GC gc) {
        int lineNumber = 0;
        gc.setBackground(this.uiFactory.getThumbnailBackgroundColor());
        gc.setForeground(this.uiFactory.getAboutDialogFontColor());
        this.drawCenteredString(Messages.getString("juploadr.ui.dialog.about.line1") + Configuration.getInstance().getVersion(), lineNumber++, gc);
        this.drawCenteredString(Messages.getString("juploadr.ui.dialog.about.line2"), lineNumber++, gc);
        this.drawCenteredString(Messages.getString("juploadr.ui.dialog.about.line3"), lineNumber++, gc);
    }

    private void drawCenteredString(String message, int offset, GC gc) {
        Point stringDimensions = gc.stringExtent(message);
        int stringWidth = stringDimensions.x;
        gc.drawString(message, 140 - stringWidth / 2, this.image.getBounds().width + 25 + offset * stringDimensions.y);
    }
}

