/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.prefs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.prefs.ConfigurationForm;
import org.scohen.juploadr.prefs.Fault;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.uploadapi.ImageUploadApi;

public class ConfigurationDialog
extends Dialog {
    private static Class[] commonFormTypes = new Class[]{class$org$scohen$juploadr$prefs$UploadActionForm == null ? (class$org$scohen$juploadr$prefs$UploadActionForm = ConfigurationDialog.class$("org.scohen.juploadr.prefs.UploadActionForm")) : class$org$scohen$juploadr$prefs$UploadActionForm, class$org$scohen$juploadr$prefs$ConnectionForm == null ? (class$org$scohen$juploadr$prefs$ConnectionForm = ConfigurationDialog.class$("org.scohen.juploadr.prefs.ConnectionForm")) : class$org$scohen$juploadr$prefs$ConnectionForm};
    private static Class[] formTypes;
    private final Collection configurationForms = new ArrayList();
    private TabFolder tabs;
    static /* synthetic */ Class class$org$scohen$juploadr$prefs$UploadActionForm;
    static /* synthetic */ Class class$org$scohen$juploadr$prefs$ConnectionForm;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Composite;
    static /* synthetic */ Class class$org$scohen$juploadr$prefs$ConfigurationForm;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Control;

    public ConfigurationDialog(Shell parent) {
        super(parent, 65536);
        Class[] apiForms = ImageUploadApi.getInstance().getConfiurationDialogs();
        formTypes = new Class[apiForms.length + commonFormTypes.length];
        System.arraycopy(apiForms, 0, formTypes, 0, apiForms.length);
        System.arraycopy(commonFormTypes, 0, formTypes, apiForms.length, commonFormTypes.length);
    }

    public void open() {
        Shell parent = this.getParent();
        Shell shell = new Shell(parent, 67680);
        shell.setText(this.getText());
        shell.setLayout((Layout)new FormLayout());
        this.tabs = this.createTabs(shell);
        Composite buttonRow = this.createButtonRow(shell);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 1);
        formData.left = new FormAttachment(0, 1);
        formData.right = new FormAttachment(100, 1);
        formData.bottom = new FormAttachment((Control)buttonRow);
        this.tabs.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.tabs);
        formData.left = new FormAttachment(0, 1);
        formData.right = new FormAttachment(100, 1);
        formData.bottom = new FormAttachment(100, 1);
        buttonRow.setLayoutData((Object)formData);
        this.tabs.pack();
        shell.pack();
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void refreshAPIForms() {
        this.open();
    }

    private TabFolder createTabs(Shell shell) {
        TabFolder tabs = new TabFolder((Composite)shell, 128);
        for (int i = 0; i < formTypes.length; ++i) {
            Class formType = formTypes[i];
            this.addConfigFormTab(tabs, formType);
        }
        return tabs;
    }

    private void addConfigFormTab(TabFolder tabs, Class formType) {
        try {
            if (!this.validateFormType(formType)) {
                return;
            }
            ConfigurationForm form = this.newForm(tabs, formType);
            TabItem tab = new TabItem(tabs, 0);
            tab.setText(form.getFormName());
            tab.setControl((Control)form);
            ((Control)form).pack();
            this.configurationForms.add(form);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private ConfigurationForm newForm(TabFolder tabs, Class formType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor constructor = formType.getConstructor(class$org$eclipse$swt$widgets$Composite == null ? (class$org$eclipse$swt$widgets$Composite = ConfigurationDialog.class$("org.eclipse.swt.widgets.Composite")) : class$org$eclipse$swt$widgets$Composite);
        ConfigurationForm form = (ConfigurationForm)constructor.newInstance(tabs);
        form.setConfigurationDialog(this);
        return form;
    }

    private boolean validateFormType(Class formType) {
        if (!(class$org$scohen$juploadr$prefs$ConfigurationForm == null ? (class$org$scohen$juploadr$prefs$ConfigurationForm = ConfigurationDialog.class$("org.scohen.juploadr.prefs.ConfigurationForm")) : class$org$scohen$juploadr$prefs$ConfigurationForm).isAssignableFrom(formType)) {
            System.err.println(formType + " is not a ConfigurationForm!");
            return false;
        }
        if (!(class$org$eclipse$swt$widgets$Control == null ? (class$org$eclipse$swt$widgets$Control = ConfigurationDialog.class$("org.eclipse.swt.widgets.Control")) : class$org$eclipse$swt$widgets$Control).isAssignableFrom(formType)) {
            System.err.println(formType + " is not a Control!");
            return false;
        }
        return true;
    }

    private Composite createButtonRow(final Shell shell) {
        Composite buttonRow = new Composite((Composite)shell, 0);
        GridLayout lay = new GridLayout(2, false);
        buttonRow.setLayout((Layout)lay);
        Button ok = new Button(buttonRow, 8);
        ok.setLayoutData((Object)new GridData(131072, 4, true, false));
        ok.setText(Messages.getString("juploadr.ui.button.ok"));
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationDialog.this.saveChanges()) {
                    shell.close();
                }
            }
        });
        Button cancel = new Button(buttonRow, 8);
        cancel.setLayoutData((Object)new GridData(131072, 4, false, false));
        cancel.setText(Messages.getString("juploadr.ui.button.cancel"));
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        buttonRow.pack();
        shell.setDefaultButton(ok);
        return buttonRow;
    }

    protected boolean saveChanges() {
        HashSet<Fault> faults = new HashSet<Fault>();
        Iterator iter = this.configurationForms.iterator();
        while (iter.hasNext()) {
            ConfigurationForm form = (ConfigurationForm)iter.next();
            Fault fault = form.validateChanges();
            if (fault == null) {
                form.saveChanges();
            } else if (fault.isFatal()) {
                MessageUtils.showErrorMessage(fault.getText());
            } else {
                form.saveChanges();
                MessageUtils.showInfoMessage(fault.getText());
            }
            faults.add(fault);
        }
        return !this.hasErrors(faults);
    }

    private boolean hasErrors(Collection faults) {
        Iterator iter = faults.iterator();
        while (iter.hasNext()) {
            Fault fault = (Fault)iter.next();
            if (fault == null || !fault.isFatal()) continue;
            return true;
        }
        return false;
    }

    public void accountChanged() {
        Iterator iter = this.configurationForms.iterator();
        while (iter.hasNext()) {
            ConfigurationForm form = (ConfigurationForm)iter.next();
            form.accountChanged();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

