/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.ui.ReusableUIFactory;

public class MessageUtils {
    public static void showErrorMessage(String message) {
        MessageUtils.showMessage(message, Messages.getString("juploadr.ui.label.error"), 1);
    }

    public static void showErrorMessage(String[] messages) {
        StringBuffer message = new StringBuffer();
        for (int i = 0; i < messages.length; ++i) {
            message.append(messages[i]);
            message.append("\n");
        }
        MessageUtils.showErrorMessage(message.toString());
    }

    public static void showInfoMessage(String message) {
        MessageUtils.showMessage(message, Messages.getString("juploadr.ui.label.information"), 2);
    }

    public static boolean showMessage(String message, String type, int iconType) {
        Display disp = ReusableUIFactory.getInstance().getDisplay();
        MessageUtils messageUtils = new MessageUtils();
        messageUtils.getClass();
        MessageBoxThread t = messageUtils.new MessageBoxThread(disp, iconType, type, message);
        disp.syncExec((Runnable)t);
        return t.isConfirmed();
    }

    private class MessageBoxThread
    extends Thread {
        private String message;
        private Display display;
        private int iconType;
        private String title;
        private int buttonId;

        public MessageBoxThread(Display display, int type, String message, String title) {
            this.display = display;
            this.iconType = type;
            this.message = message;
            this.title = title;
        }

        public void run() {
            MessageBox error = new MessageBox(this.display.getShells()[0], this.iconType);
            error.setMessage(this.title);
            error.setText(this.message);
            this.buttonId = error.open();
        }

        public boolean isConfirmed() {
            return this.buttonId == 32 || this.buttonId == 64;
        }
    }
}

