/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.scohen.juploadr.ui.ProgressDialog;
import org.scohen.juploadr.ui.ReusableUIFactory;

public abstract class Task
extends Thread {
    private ProgressDialog dialog;
    private Display display = ReusableUIFactory.getInstance().getDisplay();
    protected int min;
    protected int max;

    protected Task() {
    }

    protected void updateProgress(final int i) {
        Runnable r = new Runnable(){

            public void run() {
                if (!((Task)Task.this).dialog.bar.isDisposed()) {
                    ((Task)Task.this).dialog.bar.setSelection(i);
                }
            }
        };
        this.display.syncExec(r);
        this.updateMessage(this.getMessage());
    }

    protected void updateMessage() {
        this.updateMessage(this.getMessage());
    }

    protected void updateMessage(final String message) {
        Runnable r = new Runnable(){

            public void run() {
                String croppedMessage = Task.this.getCroppedMessage(message);
                if (!((Task)Task.this).dialog.msgLabel.isDisposed()) {
                    ((Task)Task.this).dialog.msgLabel.setText(croppedMessage);
                    ((Task)Task.this).dialog.shell.redraw();
                }
            }
        };
        this.display.syncExec(r);
    }

    private String getCroppedMessage(String message) {
        GC gc = new GC((Drawable)this.dialog.msgLabel);
        Point msgSize = this.dialog.msgLabel.getSize();
        StringBuffer cropped = new StringBuffer();
        if (gc.textExtent((String)message).x > msgSize.x) {
            String[] words = message.split(" ");
            for (int i = 0; i < words.length; ++i) {
                int oldLength = cropped.length();
                cropped.append(words[i]);
                if (gc.textExtent((String)cropped.toString()).x > msgSize.x) {
                    cropped.delete(oldLength, cropped.length());
                    cropped.append("\n");
                    cropped.append(words[i]);
                }
                cropped.append(" ");
            }
            message = cropped.toString();
        }
        gc.dispose();
        return message;
    }

    public abstract void execute();

    public abstract String getMessage();

    public final void run() {
        this.execute();
        Runnable r = new Runnable(){

            public void run() {
                Task.this.dialog.close();
            }
        };
        this.display.asyncExec(r);
    }

    public void setParent(ProgressDialog dialog) {
        this.dialog = dialog;
        dialog.setMax(this.max);
        dialog.setMin(this.min);
        dialog.setMessage(this.getMessage());
    }

    public Image getIcon() {
        return ReusableUIFactory.getInstance().getLogoImage();
    }

    public abstract String getTitle();
}

