/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui;

import org.eclipse.swt.graphics.ImageData;

public class Transforms {
    public static ImageData rotate(ImageData srcData, int direction) {
        if (direction != 0) {
            switch (direction) {
                case 270: {
                    direction = 16384;
                    break;
                }
                case 180: {
                    direction = 1024;
                    break;
                }
                case 90: {
                    direction = 131072;
                }
            }
            return Transforms.rotate_by(srcData, direction);
        }
        return srcData;
    }

    private static ImageData rotate_by(ImageData srcData, int direction) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = direction == 1024 ? srcData.width * bytesPerPixel : srcData.height * bytesPerPixel;
        byte[] newData = new byte[direction == 1024 ? srcData.height * destBytesPerLine : srcData.width * destBytesPerLine];
        int width = 0;
        int height = 0;
        for (int srcY = 0; srcY < srcData.height; ++srcY) {
            for (int srcX = 0; srcX < srcData.width; ++srcX) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                switch (direction) {
                    case 16384: {
                        destX = srcY;
                        destY = srcData.width - srcX - 1;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 131072: {
                        destX = srcData.height - srcY - 1;
                        destY = srcX;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 1024: {
                        destX = srcData.width - srcX - 1;
                        destY = srcData.height - srcY - 1;
                        width = srcData.width;
                        height = srcData.height;
                    }
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
            }
        }
        return new ImageData(width, height, srcData.depth, srcData.palette, destBytesPerLine, newData);
    }
}

