/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.ui.thumbnail;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.scohen.juploadr.app.ImageAttributes;
import org.scohen.juploadr.ui.thumbnail.Thumbnail;

public abstract class AbstractThumbnailDecorator
implements Thumbnail {
    protected Thumbnail thumb;
    protected ImageAttributes attrs;
    protected Composite parent;
    protected int THUMBNAIL_WIDTH = 96;
    protected int THUMBNAIL_HEIGHT = 96;

    public AbstractThumbnailDecorator(Composite parent, ImageAttributes atts, Thumbnail t) {
        this.parent = parent;
        this.attrs = atts;
        this.thumb = t;
        t.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                AbstractThumbnailDecorator.this.paintControl(event);
            }
        });
        t.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractThumbnailDecorator.this.widgetDisposed(e);
            }
        });
    }

    abstract void paintControl(PaintEvent var1);

    abstract void widgetDisposed(DisposeEvent var1);

    public ImageAttributes getImageAttributes() {
        return this.attrs;
    }

    public void addMouseListener(MouseListener listener) {
        this.thumb.addMouseListener(listener);
    }

    public final void redraw() {
        if (!this.thumb.isDisposed()) {
            this.thumb.redraw();
        }
    }

    public final void dispose() {
        this.thumb.dispose();
    }

    public void setEnabled(boolean enabled) {
        this.thumb.setEnabled(enabled);
    }

    public final void addPaintListener(PaintListener listener) {
        this.thumb.addPaintListener(listener);
    }

    public final void addDisposeListener(DisposeListener listener) {
        this.thumb.addDisposeListener(listener);
    }

    public final void addMouseTrackListener(MouseTrackListener listener) {
        this.thumb.addMouseTrackListener(listener);
    }

    public final void addKeyListener(KeyListener listener) {
        this.thumb.addKeyListener(listener);
    }

    public Image getImage() {
        return this.thumb.getImage();
    }

    public void setImage(Image image) {
        if (this.thumb.getImage() != null) {
            this.thumb.getImage().dispose();
        }
        this.thumb.setImage(image);
        ImageData data = image.getImageData();
        this.THUMBNAIL_WIDTH = data.width + 10 + 1;
        this.THUMBNAIL_HEIGHT = data.height + 10 + 1;
    }

    public boolean isDisposed() {
        return this.thumb.isDisposed();
    }
}

