/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.upload;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.scohen.juploadr.Messages;
import org.scohen.juploadr.app.ImageAttributesEXIFCreateDateComparator;
import org.scohen.juploadr.app.ImageAttributesRankComparator;
import org.scohen.juploadr.app.JUploadr;
import org.scohen.juploadr.app.RescaleTask;
import org.scohen.juploadr.app.UploadImage;
import org.scohen.juploadr.event.UploadStatusMonitor;
import org.scohen.juploadr.prefs.Configuration;
import org.scohen.juploadr.prefs.ConfigurationDialog;
import org.scohen.juploadr.ui.MessageUtils;
import org.scohen.juploadr.ui.ProgressDialog;
import org.scohen.juploadr.ui.ReusableUIFactory;
import org.scohen.juploadr.upload.UploaderThread;
import org.scohen.juploadr.uploadapi.ImageUploadApi;

public class UploadManager
extends SelectionAdapter {
    private Map attributes;
    private LinkedList uploadQueue;
    private UploadStatusMonitor monitor;
    private UploaderThread uploaderThread;
    private Configuration config;

    public UploadManager(Map attributes) {
        this.attributes = attributes;
        this.uploadQueue = new LinkedList();
        this.config = Configuration.getInstance();
        this.uploaderThread = new UploaderThread(this.uploadQueue, this.monitor);
        this.startUploaderThread();
    }

    public UploadManager(Map attributes, UploadStatusMonitor monitor) {
        this(attributes);
        this.monitor = monitor;
        this.uploaderThread.setMonitor(monitor);
    }

    private void startUploaderThread() {
        this.uploaderThread.setDaemon(true);
        this.uploaderThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetSelected(SelectionEvent event) {
        ImageUploadApi api = ImageUploadApi.getInstance();
        if (!api.isCurrentAccountAuthenticated()) {
            MessageUtils.showErrorMessage(Messages.getString("juploadr.ui.error.please.authorize"));
            ConfigurationDialog dialog = new ConfigurationDialog(ReusableUIFactory.getInstance().getDisplay().getShells()[0]);
            dialog.open();
        }
        if (api.isCurrentAccountAuthenticated()) {
            LinkedList list = new LinkedList(this.attributes.values());
            this.removeUploadedPhotos(list);
            Comparator sorter = null;
            sorter = this.config.getUploadByExifDate() ? new ImageAttributesEXIFCreateDateComparator() : new ImageAttributesRankComparator();
            Collections.sort(list, sorter);
            if (this.config.isProxyEnabled() && !this.config.proxySettingsValid()) {
                MessageUtils.showErrorMessage(Messages.getString("juploadr.ui.error.proxy.settings.incorrect"));
                return;
            }
            Button button = (Button)event.widget;
            if (!this.uploaderThread.isCancelled() && Messages.getString("juploadr.ui.button.upload.text.stop").equals(button.getText())) {
                this.uploaderThread.setCancelled(true);
                button.setEnabled(false);
                button.setText(Messages.getString("juploadr.ui.button.upload.text.upload"));
            } else {
                button.setText(Messages.getString("juploadr.ui.button.upload.text.stop"));
                this.uploaderThread.setCancelled(false);
                LinkedList linkedList = this.uploadQueue;
                synchronized (linkedList) {
                    if (this.config.getAutoResizePhotos()) {
                        RescaleTask rescale = new RescaleTask(list);
                        ProgressDialog pd = new ProgressDialog(JUploadr.window, rescale);
                        pd.execute();
                        list = rescale.getRescaledPhotos();
                    }
                    Iterator values = list.iterator();
                    while (values.hasNext()) {
                        UploadImage attrs = (UploadImage)values.next();
                        if (this.uploadQueue.contains(attrs)) continue;
                        this.uploadQueue.add(0, attrs);
                        this.uploadQueue.notify();
                    }
                }
            }
        }
    }

    private void removeUploadedPhotos(Collection photos) {
        Iterator iter = photos.iterator();
        while (iter.hasNext()) {
            UploadImage image = (UploadImage)iter.next();
            if (image.getState() != 4 && image.getState() != 1) continue;
            iter.remove();
        }
    }
}

