/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.util;

import java.text.DecimalFormat;
import org.scohen.juploadr.Messages;

public class ConversionUtils {
    private static final long ONE_MEG = 0x100000L;
    private static final DecimalFormat fmt = new DecimalFormat("###,###,###,##0.0");

    public static synchronized String bytesToHumanReadable(long bytes) {
        StringBuffer humanReadable = new StringBuffer();
        if (bytes < 1024L) {
            humanReadable.append(fmt.format(bytes));
            humanReadable.append(Messages.getString("juploadr.ui.label.bytes"));
        } else if (bytes < 0x100000L) {
            humanReadable.append(fmt.format((float)bytes / 1024.0f));
            humanReadable.append(Messages.getString("juploadr.ui.label.kilobytes"));
        } else if (bytes < 0x40000000L) {
            humanReadable.append(fmt.format((float)bytes / 1048576.0f));
            humanReadable.append(Messages.getString("juploadr.ui.label.megabytes"));
        } else {
            humanReadable.append(fmt.format((float)bytes / 1.0737418E9f));
            humanReadable.append(Messages.getString("juploadr.ui.label.gigabytes"));
        }
        return humanReadable.toString();
    }
}

