/*
 * Decompiled with CFR 0.152.
 */
package org.scohen.juploadr.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;

public class ObservableListDecorator
extends Observable
implements List {
    private List decorated;

    public ObservableListDecorator(List toDecorate, Observer toAdd) {
        this.decorated = toDecorate;
        this.addObserver(toAdd);
        this.changed();
    }

    public ObservableListDecorator(List toDecorate, List observers) {
        Iterator iter = observers.iterator();
        while (iter.hasNext()) {
            Observer next = (Observer)iter.next();
            this.addObserver(next);
        }
        this.decorated = toDecorate;
        this.changed();
    }

    public int size() {
        return this.decorated.size();
    }

    public void add(int index, Object element) {
        this.decorated.add(index, element);
        this.changed();
    }

    private void changed() {
        this.setChanged();
        this.notifyObservers();
    }

    public boolean add(Object o) {
        this.changed();
        return this.decorated.add(o);
    }

    public boolean addAll(Collection c) {
        boolean rv = this.decorated.addAll(c);
        this.changed();
        return rv;
    }

    public boolean addAll(int index, Collection c) {
        boolean rv = this.decorated.addAll(index, c);
        this.changed();
        return rv;
    }

    public void clear() {
        this.decorated.clear();
        this.changed();
    }

    public boolean contains(Object o) {
        return this.decorated.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.decorated.containsAll(c);
    }

    public boolean equals(Object o) {
        return ((Object)this.decorated).equals(o);
    }

    public Object get(int index) {
        return this.decorated.get(index);
    }

    public int hashCode() {
        return ((Object)this.decorated).hashCode();
    }

    public int indexOf(Object o) {
        return this.decorated.indexOf(o);
    }

    public boolean isEmpty() {
        return this.decorated.isEmpty();
    }

    public Iterator iterator() {
        return this.decorated.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.decorated.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.decorated.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.decorated.listIterator(index);
    }

    public Object remove(int index) {
        return this.decorated.remove(index);
    }

    public boolean remove(Object o) {
        boolean rv = this.decorated.remove(o);
        this.changed();
        return rv;
    }

    public boolean removeAll(Collection c) {
        boolean rv = this.decorated.removeAll(c);
        this.changed();
        return rv;
    }

    public boolean retainAll(Collection c) {
        boolean rv = this.decorated.retainAll(c);
        this.changed();
        return rv;
    }

    public Object set(int index, Object element) {
        Object rv = this.decorated.set(index, element);
        this.changed();
        return rv;
    }

    public List subList(int fromIndex, int toIndex) {
        return this.decorated.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.decorated.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.decorated.toArray(a);
    }

    public void notifyObservers(Object arg) {
        super.notifyObservers(this.decorated);
    }
}

