/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;

public abstract class AbstractTiffTagReader {
    private int _startOffset;
    private TiffTagFormat _dataFormat;
    private byte[] _data;
    private Directory _directory;
    private int _tagCount;
    private int _linkedDirectoryOffset;

    public AbstractTiffTagReader(byte[] data) {
        this._data = data;
    }

    public abstract Directory extract(Directory var1) throws TiffTagProcessingException;

    public final void processTiffTags() throws TiffTagProcessingException {
        int startOffset = this.getStartOffset();
        if (startOffset >= this._data.length || startOffset < 0) {
            throw new TiffTagProcessingException("Ignored directory marked to start outside data segement");
        }
        this.setTagCount();
        this.checkValidDirectoryLength();
        for (int dirEntry = 0; dirEntry < this._tagCount; ++dirEntry) {
            int dirEntryOffset = startOffset + 2 + 12 * dirEntry;
            int tagType = this._dataFormat.get16Bits(this._data, dirEntryOffset);
            int formatCode = this._dataFormat.get16Bits(this._data, dirEntryOffset + 2);
            if (formatCode < 0 || formatCode > 12) {
                throw new TiffTagProcessingException("Invalid format code: " + formatCode);
            }
            int componentCount = this._dataFormat.get32Bits(this._data, dirEntryOffset + 4);
            int tagValueOffset = this.calculateTagValueOffset(dirEntryOffset, formatCode, componentCount);
            if (tagValueOffset < 0) {
                throw new TiffTagProcessingException("Illegal pointer offset value in EXIF");
            }
            this.processTag(tagType, formatCode, componentCount, tagValueOffset);
        }
        this.setLinkedDirectoryOffset();
        AbstractTiffTagReader linkedReader = this.getLinkedDirectoryReader();
        if (linkedReader != null) {
            Directory linkedDirectory = linkedReader.extract(this.getDirectory());
            try {
                this.getDirectory().addLinkedDirectory(linkedDirectory);
            }
            catch (MetadataException e) {
                throw new TiffTagProcessingException(e);
            }
        }
    }

    protected abstract AbstractTiffTagReader getLinkedDirectoryReader();

    private void setTagCount() {
        this._tagCount = this._dataFormat.get16Bits(this._data, this.getStartOffset());
    }

    private void checkValidDirectoryLength() throws TiffTagProcessingException {
        int dirLength = 2 + 12 * this._tagCount + 4;
        if (dirLength + this.getStartOffset() >= this._data.length) {
            throw new TiffTagProcessingException(this._tagCount + " tags, from offset " + this.getStartOffset() + "exceeds data length " + this._data.length);
        }
    }

    private void setLinkedDirectoryOffset() {
        this._linkedDirectoryOffset = this._dataFormat.get32Bits(this._data, this.getStartOffset() + 2 + 12 * this._tagCount);
        if (this._linkedDirectoryOffset != 0 && this._linkedDirectoryOffset >= this._data.length) {
            this._linkedDirectoryOffset = 0;
        }
    }

    protected void processTag(int tagType, int formatCode, int componentCount, int tagValueOffset) throws TiffTagProcessingException {
        int byteCount = this._dataFormat.getByteCount(formatCode, componentCount);
        if (tagValueOffset + byteCount > this._data.length) {
            throw new TiffTagProcessingException("Tag length exceeds data length");
        }
        Object tagValue = this._dataFormat.parse(this._data, formatCode, componentCount, tagValueOffset);
        this._directory.setTag(tagType, formatCode, tagValue);
    }

    private int calculateTagValueOffset(int dirEntryOffset, int formatCode, int componentCount) {
        int byteCount = this._dataFormat.getByteCount(formatCode, componentCount);
        if (byteCount > 4) {
            int offsetVal = this._dataFormat.get32Bits(this._data, dirEntryOffset + 8);
            return offsetVal;
        }
        return dirEntryOffset + 8;
    }

    public int getStartOffset() {
        return this._startOffset;
    }

    protected void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    public Directory getDirectory() {
        return this._directory;
    }

    public void setDirectory(Directory directory) {
        this._directory = directory;
    }

    public byte[] getData() {
        return this._data;
    }

    public TiffTagFormat getDataFormat() {
        return this._dataFormat;
    }

    public int getLinkedDirectoryOffset() {
        return this._linkedDirectoryOffset;
    }

    public void setDataFormat(TiffTagFormat format) {
        this._dataFormat = format;
    }

    protected final void processSubDirectory(AbstractTiffTagReader reader, int tagType, int formatCode, int componentCount, int tagValueOffset) throws TiffTagProcessingException {
        int subdirOffset = this.getDataFormat().get32Bits(this.getData(), tagValueOffset);
        reader.setStartOffset(subdirOffset);
        reader.setDataFormat(this.getDataFormat());
        Directory subDirectory = reader.extract(this.getDirectory());
        this.getDirectory().addSubDirectory(tagType, formatCode, subDirectory);
    }

    protected final void processTiffHeader() throws TiffTagProcessingException {
        byte[] data = this.getData();
        if (data.length <= 8) {
            throw new TiffTagProcessingException("Invalid tiff header, expecting length > 8, length is " + data.length);
        }
        String byteOrderIdentifier = new String(data, 0, 2);
        boolean isMotorolaByteOrder = this.getByteOrder(byteOrderIdentifier);
        this.setDirectoryByteOrder(isMotorolaByteOrder);
        this.setDataFormat(new TiffTagFormat(isMotorolaByteOrder));
        int magicNumber = this.getDataFormat().get16Bits(data, 2);
        if (magicNumber != 42) {
            throw new TiffTagProcessingException("Invalid tiff header, expecting 42got " + magicNumber);
        }
        int startOffset = this.getDataFormat().get32Bits(data, 4);
        if (startOffset >= data.length - 1) {
            startOffset = 8;
        }
        this.setStartOffset(startOffset);
    }

    protected void setDirectoryByteOrder(boolean isMotorolaByteOrder) {
    }

    private boolean getByteOrder(String byteOrderIdentifier) throws TiffTagProcessingException {
        if ("MM".equals(byteOrderIdentifier)) {
            return true;
        }
        if ("II".equals(byteOrderIdentifier)) {
            return false;
        }
        throw new TiffTagProcessingException("Invalid byte order identifier: " + byteOrderIdentifier);
    }
}

