/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif;

import au.com.lastweekend.jim.io.exif.AbstractTiffTagReader;
import au.com.lastweekend.jim.io.exif.ExifDirectory;
import au.com.lastweekend.jim.io.exif.ExifInteropDirectoryReader;
import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteException;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteReader;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteRegistry;
import au.com.lastweekend.jim.io.metadata.Directory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExifDirectoryReader
extends AbstractTiffTagReader {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$exif$ExifDirectoryReader == null ? (class$au$com$lastweekend$jim$io$exif$ExifDirectoryReader = ExifDirectoryReader.class$("au.com.lastweekend.jim.io.exif.ExifDirectoryReader")) : class$au$com$lastweekend$jim$io$exif$ExifDirectoryReader));
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$exif$ExifDirectoryReader;

    public ExifDirectoryReader(byte[] data) {
        super(data);
    }

    public Directory extract(Directory parentDirectory) throws TiffTagProcessingException {
        this.setDirectory(new ExifDirectory(parentDirectory));
        this.processTiffTags();
        return this.getDirectory();
    }

    protected AbstractTiffTagReader getLinkedDirectoryReader() {
        return null;
    }

    protected void processTag(int tagType, int formatCode, int componentCount, int tagValueOffset) throws TiffTagProcessingException {
        switch (tagType) {
            case 37500: {
                this.extractMakerNote(tagType, formatCode, componentCount, tagValueOffset);
                break;
            }
            case 40965: {
                this.processSubDirectory(new ExifInteropDirectoryReader(this.getData()), tagType, formatCode, componentCount, tagValueOffset);
                break;
            }
            case 37510: {
                this.extractUserComment(tagType, formatCode, componentCount, tagValueOffset);
                break;
            }
            default: {
                super.processTag(tagType, formatCode, componentCount, tagValueOffset);
            }
        }
    }

    private void extractUserComment(int tagType, int formatCode, int componentCount, int tagValueOffset) throws TiffTagProcessingException {
        Object tagValue = this.getDataFormat().parse(this.getData(), formatCode, componentCount, tagValueOffset);
        if (tagValue instanceof String) {
            tagValue = this.readCommentString((String)tagValue, tagValueOffset, componentCount, formatCode);
        }
    }

    private String readCommentString(String rawValue, int tagValueOffset, int componentCount, int formatCode) throws TiffTagProcessingException {
        byte[] data = this.getData();
        if (rawValue.startsWith("ASCII")) {
            for (int i = 5; i < 10; ++i) {
                byte b = data[tagValueOffset + i];
                if (b == 0 || b == 32) continue;
                return (String)this.getDataFormat().parse(data, formatCode, componentCount - i, tagValueOffset + i);
            }
        }
        return rawValue;
    }

    private void extractMakerNote(int tagType, int formatCode, int componentCount, int tagValueOffset) throws TiffTagProcessingException {
        Directory makernoteDirectory;
        MakernoteReader reader = MakernoteRegistry.getReader((ExifDirectory)this.getDirectory(), this.getDataFormat(), this.getData(), formatCode, componentCount, tagValueOffset);
        try {
            makernoteDirectory = reader.extractMakernote(this.getDirectory());
        }
        catch (MakernoteException e) {
            LOG.warn((Object)"Error reading makernote, treating as unknown", (Throwable)e);
            reader = MakernoteRegistry.getUnknownMakernoteReader((ExifDirectory)this.getDirectory(), this.getDataFormat(), this.getData(), formatCode, componentCount, tagValueOffset);
            try {
                makernoteDirectory = reader.extractMakernote(this.getDirectory());
            }
            catch (MakernoteException e1) {
                throw new TiffTagProcessingException("Can't use unkownMakernoteReader to reader makernote data", e1);
            }
        }
        this.getDirectory().addSubDirectory(tagType, formatCode, makernoteDirectory);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

