/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote;

import au.com.lastweekend.jim.io.exif.ExifDirectory;
import au.com.lastweekend.jim.io.exif.ExifDirectoryWriter;
import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteReader;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteWriter;
import au.com.lastweekend.jim.io.exif.makernote.UnknownMakernoteDirectory;
import au.com.lastweekend.jim.io.exif.makernote.UnknownMakernoteReader;
import au.com.lastweekend.jim.io.exif.makernote.UnknownMakernoteWriter;
import au.com.lastweekend.jim.io.exif.makernote.minolta.MinoltaMakerNoteReader;
import au.com.lastweekend.jim.io.exif.makernote.minolta.MinoltaMakernoteDirectory;
import au.com.lastweekend.jim.io.exif.makernote.minolta.MinoltaMakernoteWriter;
import au.com.lastweekend.jim.io.metadata.Directory;

public final class MakernoteRegistry {
    private MakernoteRegistry() throws InstantiationException {
        throw new InstantiationException("How did you get here");
    }

    public static MakernoteReader getReader(ExifDirectory directory, TiffTagFormat dataFormat, byte[] data, int formatCode, int componentCount, int tagValueOffset) {
        String cameraMake = directory.getParentDirectory().getString(271);
        if (cameraMake != null && cameraMake.length() >= 7 && "Minolta".equalsIgnoreCase(cameraMake.substring(0, 7)) && "MLT0".equals(new String(data, tagValueOffset + 10, 4))) {
            return new MinoltaMakerNoteReader(directory, dataFormat, data, formatCode, componentCount, tagValueOffset);
        }
        return MakernoteRegistry.getUnknownMakernoteReader(directory, dataFormat, data, formatCode, componentCount, tagValueOffset);
    }

    public static MakernoteWriter getWriter(ExifDirectoryWriter parentWriter, Directory directory, int startOffset) {
        if (directory instanceof MinoltaMakernoteDirectory) {
            return new MinoltaMakernoteWriter((MinoltaMakernoteDirectory)directory, parentWriter.getExifTransform(), parentWriter.getDataFormat(), startOffset);
        }
        if (directory instanceof UnknownMakernoteDirectory) {
            return new UnknownMakernoteWriter((UnknownMakernoteDirectory)directory, startOffset);
        }
        throw new RuntimeException("We've read a makernote directory, but don't know how to write it");
    }

    public static MakernoteReader getUnknownMakernoteReader(ExifDirectory directory, TiffTagFormat dataFormat, byte[] data, int formatCode, int componentCount, int tagValueOffset) {
        return new UnknownMakernoteReader(data, formatCode, componentCount, tagValueOffset);
    }
}

