/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.canon;

import au.com.lastweekend.jim.io.exif.ExifDirectory;
import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteReader;
import au.com.lastweekend.jim.io.exif.makernote.SimpleMakernoteReader;
import au.com.lastweekend.jim.io.exif.makernote.canon.CanonMakernoteDirectory;
import au.com.lastweekend.jim.io.metadata.Directory;

public class CanonMakerNoteReader
extends SimpleMakernoteReader
implements MakernoteReader {
    public CanonMakerNoteReader(ExifDirectory directory, TiffTagFormat dataFormat, byte[] data, int formatCode, int componentCount, int tagValueOffset) {
        super(directory, new TiffTagFormat(false), data, formatCode, componentCount, tagValueOffset);
    }

    protected Directory getDirectoryInstance(Directory parent) {
        return new CanonMakernoteDirectory(parent);
    }

    protected void processTag(int tagType, int formatCode, int componentCount, int tagValueOffset) throws TiffTagProcessingException {
        if (tagType == 1) {
            this.processInts(49408, formatCode, componentCount, tagValueOffset);
        } else if (tagType == 4) {
            this.processInts(49664, formatCode, componentCount, tagValueOffset);
        } else {
            super.processTag(tagType, formatCode, componentCount, tagValueOffset);
        }
    }

    private void processInts(int subTagTypeBase, int formatCode, int componentCount, int tagValueOffset) throws TiffTagProcessingException {
        TiffTagFormat format = this.getDataFormat();
        int[] ints = (int[])format.parse(this.getData(), formatCode, componentCount, tagValueOffset);
        for (int i = 1; i < ints.length; ++i) {
            this.getDirectory().setTag(subTagTypeBase + i, formatCode, new Integer(ints[i]));
        }
    }
}

