/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.fujifilm;

import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.io.metadata.TagDescriptor;
import au.com.lastweekend.jim.util.Rational;

public class FujifilmMakernoteDescriptor
extends TagDescriptor {
    public FujifilmMakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 4097: {
                return this.getSharpnessDescription();
            }
            case 4098: {
                return this.getWhiteBalanceDescription();
            }
            case 4099: {
                return this.getColorDescription();
            }
            case 4100: {
                return this.getToneDescription();
            }
            case 4112: {
                return this.getFlashModeDescription();
            }
            case 4113: {
                return this.getFlashStrengthDescription();
            }
            case 4128: {
                return this.getMacroDescription();
            }
            case 4129: {
                return this.getFocusModeDescription();
            }
            case 4144: {
                return this.getSlowSyncDescription();
            }
            case 4145: {
                return this.getPictureModeDescription();
            }
            case 4352: {
                return this.getContinuousTakingOrAutoBrackettingDescription();
            }
            case 4864: {
                return this.getBlurWarningDescription();
            }
            case 4865: {
                return this.getFocusWarningDescription();
            }
            case 4866: {
                return this.getAutoExposureWarningDescription();
            }
        }
        return this.getDirectory().getString(tagType);
    }

    private String getAutoExposureWarningDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4866)) {
            return null;
        }
        int value = this.getDirectory().getInt(4866);
        switch (value) {
            case 0: {
                return "AE good";
            }
            case 1: {
                return "Over exposed (>1/1000s @ F11)";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getFocusWarningDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4865)) {
            return null;
        }
        int value = this.getDirectory().getInt(4865);
        switch (value) {
            case 0: {
                return "Auto focus good";
            }
            case 1: {
                return "Out of focus";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getBlurWarningDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4864)) {
            return null;
        }
        int value = this.getDirectory().getInt(4864);
        switch (value) {
            case 0: {
                return "No blur warning";
            }
            case 1: {
                return "Blur warning";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getContinuousTakingOrAutoBrackettingDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4352)) {
            return null;
        }
        int value = this.getDirectory().getInt(4352);
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getPictureModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4145)) {
            return null;
        }
        int value = this.getDirectory().getInt(4145);
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Portrait scene";
            }
            case 2: {
                return "Landscape scene";
            }
            case 4: {
                return "Sports scene";
            }
            case 5: {
                return "Night scene";
            }
            case 6: {
                return "Program AE";
            }
            case 256: {
                return "Aperture priority AE";
            }
            case 512: {
                return "Shutter priority AE";
            }
            case 768: {
                return "Manual exposure";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getSlowSyncDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4144)) {
            return null;
        }
        int value = this.getDirectory().getInt(4144);
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getFocusModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4129)) {
            return null;
        }
        int value = this.getDirectory().getInt(4129);
        switch (value) {
            case 0: {
                return "Auto focus";
            }
            case 1: {
                return "Manual focus";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getMacroDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4128)) {
            return null;
        }
        int value = this.getDirectory().getInt(4128);
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getFlashStrengthDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4113)) {
            return null;
        }
        Rational value = this.getDirectory().getRational(4113);
        return value.toSimpleString(false) + " eV (Apex)";
    }

    private String getFlashModeDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4112)) {
            return null;
        }
        int value = this.getDirectory().getInt(4112);
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Off";
            }
            case 3: {
                return "Red-eye reduction";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getToneDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4100)) {
            return null;
        }
        int value = this.getDirectory().getInt(4100);
        switch (value) {
            case 0: {
                return "Normal (STD)";
            }
            case 256: {
                return "High (HARD)";
            }
            case 512: {
                return "Low (ORG)";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getColorDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4099)) {
            return null;
        }
        int value = this.getDirectory().getInt(4099);
        switch (value) {
            case 0: {
                return "Normal (STD)";
            }
            case 256: {
                return "High";
            }
            case 512: {
                return "Low (ORG)";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getWhiteBalanceDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4098)) {
            return null;
        }
        int value = this.getDirectory().getInt(4098);
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 256: {
                return "Daylight";
            }
            case 512: {
                return "Cloudy";
            }
            case 768: {
                return "DaylightColor-fluorescence";
            }
            case 769: {
                return "DaywhiteColor-fluorescence";
            }
            case 770: {
                return "White-fluorescence";
            }
            case 1024: {
                return "Incandenscense";
            }
            case 3840: {
                return "Custom white balance";
            }
        }
        return "Unknown (" + value + ")";
    }

    private String getSharpnessDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(4097)) {
            return null;
        }
        int value = this.getDirectory().getInt(4097);
        switch (value) {
            case 1: 
            case 2: {
                return "Soft";
            }
            case 3: {
                return "Normal";
            }
            case 4: 
            case 5: {
                return "Hard";
            }
        }
        return "Unknown (" + value + ")";
    }
}

