/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.minolta;

import au.com.lastweekend.jim.io.exif.ExifDirectory;
import au.com.lastweekend.jim.io.exif.TiffTagFormat;
import au.com.lastweekend.jim.io.exif.TiffTagProcessingException;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteException;
import au.com.lastweekend.jim.io.exif.makernote.MakernoteReader;
import au.com.lastweekend.jim.io.exif.makernote.SimpleMakernoteReader;
import au.com.lastweekend.jim.io.exif.makernote.minolta.MinoltaCameraSettingsReader;
import au.com.lastweekend.jim.io.exif.makernote.minolta.MinoltaMakernoteDirectory;
import au.com.lastweekend.jim.io.metadata.Directory;

public class MinoltaMakerNoteReader
extends SimpleMakernoteReader
implements MakernoteReader {
    public MinoltaMakerNoteReader(ExifDirectory directory, TiffTagFormat dataFormat, byte[] data, int formatCode, int componentCount, int tagValueOffset) {
        super(directory, dataFormat, data, formatCode, componentCount, tagValueOffset);
    }

    protected Directory getDirectoryInstance(Directory parent) {
        return new MinoltaMakernoteDirectory(parent);
    }

    protected void processTag(int tagType, int formatCode, int componentCount, int tagValueOffset) throws TiffTagProcessingException {
        if (tagType == 0) {
            formatCode = 2;
            super.processTag(tagType, formatCode, componentCount, tagValueOffset);
        } else if (tagType == 129) {
            int byteCount = this.getDataFormat().getByteCount(formatCode, componentCount);
            if (tagValueOffset + byteCount > this.getData().length) {
                return;
            }
            super.processTag(tagType, formatCode, componentCount, tagValueOffset);
        } else if (tagType == 1 || tagType == 3) {
            Directory subDirectory;
            MinoltaCameraSettingsReader reader = new MinoltaCameraSettingsReader(this.getData(), formatCode, componentCount, tagValueOffset);
            try {
                subDirectory = reader.extract(this.getDirectory());
            }
            catch (MakernoteException e) {
                throw new TiffTagProcessingException(e);
            }
            this.getDirectory().addSubDirectory(tagType, formatCode, subDirectory);
        } else {
            super.processTag(tagType, formatCode, componentCount, tagValueOffset);
        }
    }
}

