/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.exif.makernote.nikon;

import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.MetadataException;
import au.com.lastweekend.jim.io.metadata.TagDescriptor;
import au.com.lastweekend.jim.util.Rational;

public class NikonType2MakernoteDescriptor
extends TagDescriptor {
    public NikonType2MakernoteDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 2: {
                return this.getIsoSettingDescription();
            }
            case 134: {
                return this.getDigitalZoomDescription();
            }
            case 136: {
                return this.getAutoFocusPositionDescription();
            }
        }
        return this.getDirectory().getString(tagType);
    }

    private String getAutoFocusPositionDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(136)) {
            return null;
        }
        int[] values = this.getDirectory().getIntArray(136);
        if (values.length != 4 || values[0] != 0 || values[2] != 0 || values[3] != 0) {
            return "Unknown (" + this.getDirectory().getString(136) + ")";
        }
        switch (values[1]) {
            case 0: {
                return "Centre";
            }
            case 1: {
                return "Top";
            }
            case 2: {
                return "Bottom";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return "Unknown (" + values[1] + ")";
    }

    private String getDigitalZoomDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(134)) {
            return null;
        }
        Rational rational = this.getDirectory().getRational(134);
        if (rational.intValue() == 1) {
            return "No digital zoom";
        }
        return rational.toSimpleString(true) + "x digital zoom";
    }

    private String getIsoSettingDescription() throws MetadataException {
        if (!this.getDirectory().containsTag(2)) {
            return null;
        }
        int[] values = this.getDirectory().getIntArray(2);
        if (values[0] != 0 || values[1] == 0) {
            return "Unknown (" + this.getDirectory().getString(2) + ")";
        }
        return "ISO " + values[1];
    }
}

