/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.write.DefaultDirectoryWriterRegistry;
import au.com.lastweekend.jim.io.jpeg.write.JpegDirectoryWriter;
import au.com.lastweekend.jim.io.jpeg.write.JpegDirectoryWriterRegistry;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.Metadata;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class JpegWriter {
    private static final JpegDirectoryWriterRegistry DEFAULT_REGISTRY = new DefaultDirectoryWriterRegistry();
    private final JpegDirectoryWriterRegistry _registry;

    public JpegWriter() {
        this(DEFAULT_REGISTRY);
    }

    public JpegWriter(JpegDirectoryWriterRegistry registry) {
        this._registry = registry;
    }

    public void writeImage(Metadata metadata, File file) throws JpegProcessingException {
        BufferedOutputStream outStream = this.getBufferedOutputStream(file);
        this.writeImage(metadata, outStream);
        this.closeStream(outStream);
    }

    public void writeImage(Metadata metadata, OutputStream output) throws JpegProcessingException {
        this.writeJpegHeader(output);
        this.writeDirectories(metadata, output);
        this.writeEndOfImage(output);
    }

    private void writeJpegHeader(OutputStream output) throws JpegProcessingException {
        byte[] headerBytes = new byte[]{-1, -40};
        try {
            output.write(headerBytes);
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
    }

    public void writeDirectories(Metadata metadata, OutputStream output) throws JpegProcessingException {
        Iterator directoryIterator = metadata.getDirectoryIterator();
        while (directoryIterator.hasNext()) {
            Directory directory = (Directory)directoryIterator.next();
            JpegDirectoryWriter segmentWriter = this._registry.getDirectoryWriter(directory);
            if (segmentWriter == null) continue;
            segmentWriter.writeDirectory(directory, output);
        }
    }

    private void writeEndOfImage(OutputStream output) throws JpegProcessingException {
        try {
            output.write(-1);
            output.write(-39);
        }
        catch (IOException e) {
            throw new JpegProcessingException("Error writing end of image", e);
        }
    }

    private BufferedOutputStream getBufferedOutputStream(File jpegFile) throws JpegProcessingException {
        try {
            FileOutputStream outStream = new FileOutputStream(jpegFile);
            return new BufferedOutputStream(outStream);
        }
        catch (FileNotFoundException e) {
            throw new JpegProcessingException(e);
        }
    }

    private void closeStream(OutputStream outStream) throws JpegProcessingException {
        try {
            outStream.close();
        }
        catch (IOException e) {
            throw new JpegProcessingException("Error closing output stream", e);
        }
    }
}

