/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg;

import au.com.lastweekend.jim.io.jpeg.JpegSegment;
import au.com.lastweekend.jim.io.metadata.Directory;
import java.util.HashMap;

public class RawJpegSegmentDirectory
extends Directory {
    private JpegSegment _segment;
    private static final int FMT_INT = 1;
    private static final int FMT_BYTE_ARRAY = 2;
    private static final int FMT_BYTE = 3;

    public RawJpegSegmentDirectory(JpegSegment segment) {
        this(null, segment);
    }

    public RawJpegSegmentDirectory(Directory parent, JpegSegment segment) {
        super(parent);
        this._segment = segment;
    }

    public String getName() {
        return "Unknown Jpeg Segment";
    }

    protected HashMap getTagNameMap() {
        return new HashMap();
    }

    public JpegSegment getSegment() {
        return this._segment;
    }

    public void setValue(int tagType, int value) {
        this.setTag(tagType, 1, new Integer(value));
    }

    public void setValue(int tagType, byte value) {
        this.setTag(tagType, 3, new Byte(value));
    }

    public void setValue(int tagType, byte[] value) {
        this.setTag(tagType, 2, value);
    }

    protected byte getByteArrayValue(int tagType, int index) {
        byte[] byteArrayObject = (byte[])this.getObject(tagType);
        return byteArrayObject[index];
    }
}

