/*
 * Decompiled with CFR 0.152.
 */
package au.com.lastweekend.jim.io.jpeg.read;

import au.com.lastweekend.jim.io.jpeg.HuffmanTable;
import au.com.lastweekend.jim.io.jpeg.HuffmanTableDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegImageDataDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegProcessingException;
import au.com.lastweekend.jim.io.jpeg.JpegRestartIntervalDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegScanDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegStartOfFrameDirectory;
import au.com.lastweekend.jim.io.jpeg.JpegStartOfScanDirectory;
import au.com.lastweekend.jim.io.jpeg.Scan;
import au.com.lastweekend.jim.io.metadata.Directory;
import au.com.lastweekend.jim.io.metadata.Metadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JpegCompressedDataReader {
    private static final Log LOG = LogFactory.getLog((Class)(class$au$com$lastweekend$jim$io$jpeg$read$JpegCompressedDataReader == null ? (class$au$com$lastweekend$jim$io$jpeg$read$JpegCompressedDataReader = JpegCompressedDataReader.class$("au.com.lastweekend.jim.io.jpeg.read.JpegCompressedDataReader")) : class$au$com$lastweekend$jim$io$jpeg$read$JpegCompressedDataReader));
    private InputStream _inStream;
    private static final int CHUNK_SIZE = 4096;
    static /* synthetic */ Class class$au$com$lastweekend$jim$io$jpeg$read$JpegCompressedDataReader;

    public JpegCompressedDataReader(InputStream inStream) {
        this._inStream = inStream;
    }

    public void readTransformableData(Metadata metadata) throws JpegProcessingException {
        byte componentID;
        int i;
        Scan scan = new Scan();
        JpegStartOfFrameDirectory startOfFrameDirectory = null;
        JpegStartOfScanDirectory startOfScanDirectory = null;
        Iterator directoryIterator = metadata.getDirectoryIterator();
        while (directoryIterator.hasNext()) {
            Directory directory = (Directory)directoryIterator.next();
            if (directory instanceof JpegStartOfFrameDirectory) {
                startOfFrameDirectory = (JpegStartOfFrameDirectory)directory;
                continue;
            }
            if (directory instanceof HuffmanTableDirectory) {
                HuffmanTableDirectory huffmanDirectory = (HuffmanTableDirectory)directory;
                byte tableIndex = huffmanDirectory.getTableID();
                scan.setHuffmanDecoder(huffmanDirectory.isACTable(), tableIndex, new HuffmanTable(huffmanDirectory.getHuffmanValues()));
                continue;
            }
            if (directory instanceof JpegStartOfScanDirectory) {
                startOfScanDirectory = (JpegStartOfScanDirectory)directory;
                continue;
            }
            if (!(directory instanceof JpegRestartIntervalDirectory)) continue;
            JpegRestartIntervalDirectory restartIntervalDirectory = (JpegRestartIntervalDirectory)directory;
            int restartInterval = restartIntervalDirectory.getRestartInterval();
            scan.setRestartInterval(restartInterval);
        }
        int numberOfComponents = startOfFrameDirectory.getNumberOfComponents();
        int frameWidth = startOfFrameDirectory.getFrameWidth();
        int frameHeight = startOfFrameDirectory.getFrameHeight();
        scan.setHeight(frameHeight);
        scan.setWidth(frameWidth);
        for (i = 0; i < numberOfComponents; ++i) {
            componentID = startOfFrameDirectory.getComponentID(i);
            byte horizontalSamplingFactor = startOfFrameDirectory.getHorizontalSamplingFactor(i);
            byte verticalSamplingFactor = startOfFrameDirectory.getVerticalSamplingFactor(i);
            scan.createComponent(componentID, horizontalSamplingFactor, verticalSamplingFactor);
        }
        if (numberOfComponents != startOfScanDirectory.getNumberOfComponents()) {
            throw new JpegProcessingException("Mismatched component count in SOF and SOS headers");
        }
        for (i = 0; i < numberOfComponents; ++i) {
            componentID = startOfScanDirectory.getComponentID(i);
            byte acDecoderIndex = startOfScanDirectory.getACTableID(i);
            byte dcDecoderIndex = startOfScanDirectory.getDCTableID(i);
            scan.setComponentDecoders(componentID, dcDecoderIndex, acDecoderIndex);
        }
        scan.read(this._inStream);
        this.checkEndOfImage();
        JpegScanDirectory imageDataDirectory = new JpegScanDirectory();
        imageDataDirectory.setScan(scan);
        metadata.addDirectory(imageDataDirectory);
    }

    private void checkEndOfImage() throws JpegProcessingException {
        try {
            byte markerBoundary = (byte)this._inStream.read();
            byte endOfImageMarker = (byte)this._inStream.read();
            if (markerBoundary == -1 && endOfImageMarker >= -48 && endOfImageMarker <= -41) {
                LOG.debug((Object)("Found terminating restart marker " + Integer.toHexString(endOfImageMarker)));
                markerBoundary = (byte)this._inStream.read();
                endOfImageMarker = (byte)this._inStream.read();
            }
            if (markerBoundary != -1 || endOfImageMarker != -39) {
                int toEndOfFile = 0;
                while (this._inStream.read() >= 0) {
                    ++toEndOfFile;
                }
                throw new JpegProcessingException("Expecting end of image markers, but found " + Integer.toHexString(markerBoundary) + ", " + Integer.toHexString(endOfImageMarker) + ", " + toEndOfFile + " bytes from end of file");
            }
        }
        catch (IOException e) {
            throw new JpegProcessingException(e);
        }
    }

    public void readRawData(Metadata metadata) throws JpegProcessingException {
        boolean endOfImage = false;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        int readCount = 0;
        int prevByte = 0;
        byte[] dataChunk = new byte[4096];
        while (!endOfImage) {
            int next;
            if (readCount == 4096) {
                chunks.add(dataChunk);
                readCount = 0;
                dataChunk = new byte[4096];
            }
            try {
                next = this._inStream.read();
            }
            catch (IOException e) {
                throw new JpegProcessingException(e);
            }
            byte nextByte = (byte)(next & 0xFF);
            if (next < 0) {
                throw new JpegProcessingException("End of file before End Of Image marker");
            }
            if (prevByte == -1 && nextByte == -39) {
                --readCount;
                chunks.add(dataChunk);
                endOfImage = true;
                continue;
            }
            dataChunk[readCount] = prevByte = (int)nextByte;
            ++readCount;
        }
        int imageDataSize = (chunks.size() - 1) * 4096 + readCount;
        byte[] imageData = new byte[imageDataSize];
        Iterator iterator = chunks.iterator();
        for (int i = 0; i < imageDataSize; ++i) {
            int j = i % 4096;
            if (j == 0) {
                dataChunk = (byte[])iterator.next();
            }
            imageData[i] = dataChunk[j];
        }
        metadata.addDirectory(new JpegImageDataDirectory(imageData));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

